/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.Cached;
import com.github.yoojia.events.EventPayload;
import com.github.yoojia.events.SharedScheduler;
import com.github.yoojia.events.SubscriberArray;
import com.github.yoojia.events.emitter.DeadEvent;
import com.github.yoojia.events.emitter.EventEmitter;
import com.github.yoojia.events.emitter.EventFilter;
import com.github.yoojia.events.emitter.EventInterceptor;
import com.github.yoojia.events.emitter.Logger;
import com.github.yoojia.events.emitter.RealSubscriber;
import com.github.yoojia.events.emitter.Scheduler;
import com.github.yoojia.events.emitter.Subscriber;
import com.github.yoojia.events.supports.Filter;
import com.github.yoojia.events.supports.Preconditions;
import java.lang.reflect.Method;
import java.util.List;

public class NextEvents {
    private final EventEmitter mEmitter;
    private final Cached mObjectCached = new Cached();

    public NextEvents() {
        this(SharedScheduler.getDefault());
    }

    public NextEvents(Scheduler scheduler) {
        this.mEmitter = new EventEmitter(Preconditions.notNull(scheduler, "scheduler == null"));
        this.addEventInterceptor(new DeadEventInterceptor(this));
    }

    public void register(Object object) {
        this.register(object, null);
    }

    public void register(Object object, Filter<Method> methodFilter) {
        Preconditions.notNull(object, "object == null");
        SubscriberArray subscribers = this.mObjectCached.findTargets(object, methodFilter);
        for (RealSubscriber subscriber : subscribers) {
            this.mEmitter.addSubscriber(subscriber);
        }
    }

    public void unregister(Object object) {
        Preconditions.notNull(object, "object == null");
        SubscriberArray subscribers = this.mObjectCached.getPresent(object);
        if (!subscribers.isEmpty()) {
            for (RealSubscriber subscriber : subscribers) {
                this.mEmitter.removeSubscriber(subscriber);
            }
            this.mObjectCached.remove(object);
        }
    }

    public void just(String name) {
        this.mEmitter.emit(new EventPayload(name, null));
    }

    public void emit(String name, Object ... payloads) {
        this.mEmitter.emit(new EventPayload(name, payloads));
    }

    public void emit(EventPayload event) {
        this.mEmitter.emit(Preconditions.notNull(event, "event == null"));
    }

    public void addSubscriber(Subscriber subscriber, EventFilter filter) {
        this.mEmitter.addSubscriber(Preconditions.notNull(subscriber, "subscriber == null"), Preconditions.notNull(filter, "filter == null"));
    }

    public void addSubscriber(Subscriber subscriber, List<EventFilter> filters) {
        this.mEmitter.addSubscriber(Preconditions.notNull(subscriber, "subscriber == null"), Preconditions.notNull(filters, "filters == null"));
    }

    public void removeSubscriber(Subscriber subscriber) {
        this.mEmitter.removeSubscriber(subscriber);
    }

    public void addEventInterceptor(EventInterceptor handler) {
        this.mEmitter.addEventInterceptor(handler);
    }

    public void removeEventInterceptor(EventInterceptor handler) {
        this.mEmitter.removeEventInterceptor(handler);
    }

    private static class DeadEventInterceptor
    implements EventInterceptor {
        private final NextEvents mEvents;

        private DeadEventInterceptor(NextEvents mEvents) {
            this.mEvents = mEvents;
        }

        @Override
        public boolean handle(Object event) {
            boolean isDeadEvent = event instanceof DeadEvent;
            if (isDeadEvent) {
                EventPayload payload = (EventPayload)((DeadEvent)event).origin;
                if ("next.events.dead-event".equals(payload.name)) {
                    Logger.debug("NextEvents", "- Empty handlers for dead-event: " + payload);
                } else {
                    this.mEvents.emit(new EventPayload("next.events.dead-event", payload));
                }
            }
            return isDeadEvent;
        }
    }
}

