/*
 * Decompiled with CFR 0.152.
 */
package com.lzh.easythread;

import com.lzh.easythread.AndroidDeliver;
import com.lzh.easythread.AsyncCallback;
import com.lzh.easythread.CallableWrapper;
import com.lzh.easythread.Callback;
import com.lzh.easythread.Configs;
import com.lzh.easythread.JavaDeliver;
import com.lzh.easythread.RunnableWrapper;
import com.lzh.easythread.Tools;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class EasyThread
implements Executor {
    private ExecutorService pool;
    private String defName;
    private Callback defCallback;
    private Executor defDeliver;
    private ThreadLocal<Configs> local;

    private EasyThread(int type, int size, int priority, String name, Callback callback, Executor deliver, ExecutorService pool) {
        if (pool == null) {
            pool = this.createPool(type, size, priority);
        }
        this.pool = pool;
        this.defName = name;
        this.defCallback = callback;
        this.defDeliver = deliver;
        this.local = new ThreadLocal();
    }

    public EasyThread setName(String name) {
        this.getLocalConfigs().name = name;
        return this;
    }

    public EasyThread setCallback(Callback callback) {
        this.getLocalConfigs().callback = callback;
        return this;
    }

    public EasyThread setDelay(long time, TimeUnit unit) {
        long delay;
        this.getLocalConfigs().delay = delay = unit.toMillis(time);
        return this;
    }

    public EasyThread setDeliver(Executor deliver) {
        this.getLocalConfigs().deliver = deliver;
        return this;
    }

    @Override
    public void execute(Runnable runnable) {
        runnable = new RunnableWrapper(this.getLocalConfigs()).setRunnable(runnable);
        this.pool.execute(runnable);
        this.resetLocalConfigs();
    }

    public <T> void async(Callable<T> callable, AsyncCallback<T> callback) {
        Configs configs = this.getLocalConfigs();
        configs.asyncCallback = callback;
        RunnableWrapper runnable = new RunnableWrapper(configs).setCallable(callable);
        this.pool.execute(runnable);
        this.resetLocalConfigs();
    }

    public <T> Future<T> submit(Callable<T> callable) {
        callable = new CallableWrapper<T>(this.getLocalConfigs(), callable);
        Future<T> result = this.pool.submit(callable);
        this.resetLocalConfigs();
        return result;
    }

    public ExecutorService getExecutor() {
        return this.pool;
    }

    private ExecutorService createPool(int type, int size, int priority) {
        switch (type) {
            case 0: {
                return Executors.newCachedThreadPool(new DefaultFactory(priority));
            }
            case 1: {
                return Executors.newFixedThreadPool(size, new DefaultFactory(priority));
            }
            case 3: {
                return Executors.newScheduledThreadPool(size, new DefaultFactory(priority));
            }
        }
        return Executors.newSingleThreadExecutor(new DefaultFactory(priority));
    }

    private synchronized void resetLocalConfigs() {
        this.local.set(null);
    }

    private synchronized Configs getLocalConfigs() {
        Configs configs = this.local.get();
        if (configs == null) {
            configs = new Configs();
            configs.name = this.defName;
            configs.callback = this.defCallback;
            configs.deliver = this.defDeliver;
            this.local.set(configs);
        }
        return configs;
    }

    public static class Builder {
        static final int TYPE_CACHEABLE = 0;
        static final int TYPE_FIXED = 1;
        static final int TYPE_SINGLE = 2;
        static final int TYPE_SCHEDULED = 3;
        int type;
        int size;
        int priority = 5;
        String name;
        Callback callback;
        Executor deliver;
        ExecutorService pool;

        private Builder(int size, int type, ExecutorService pool) {
            this.size = Math.max(1, size);
            this.type = type;
            this.pool = pool;
        }

        public static Builder create(ExecutorService pool) {
            return new Builder(1, 2, pool);
        }

        public static Builder createCacheable() {
            return new Builder(0, 0, null);
        }

        public static Builder createFixed(int size) {
            return new Builder(size, 1, null);
        }

        public static Builder createScheduled(int size) {
            return new Builder(size, 3, null);
        }

        public static Builder createSingle() {
            return new Builder(0, 2, null);
        }

        public Builder setName(String name) {
            if (!Tools.isEmpty(name)) {
                this.name = name;
            }
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setCallback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public Builder setDeliver(Executor deliver) {
            this.deliver = deliver;
            return this;
        }

        public EasyThread build() {
            this.priority = Math.max(1, this.priority);
            this.priority = Math.min(10, this.priority);
            this.size = Math.max(1, this.size);
            if (Tools.isEmpty(this.name)) {
                switch (this.type) {
                    case 0: {
                        this.name = "CACHEABLE";
                        break;
                    }
                    case 1: {
                        this.name = "FIXED";
                        break;
                    }
                    case 2: {
                        this.name = "SINGLE";
                        break;
                    }
                    default: {
                        this.name = "EasyThread";
                    }
                }
            }
            if (this.deliver == null) {
                this.deliver = Tools.isAndroid ? AndroidDeliver.getInstance() : JavaDeliver.getInstance();
            }
            return new EasyThread(this.type, this.size, this.priority, this.name, this.callback, this.deliver, this.pool);
        }
    }

    private static class DefaultFactory
    implements ThreadFactory {
        private int priority;

        DefaultFactory(int priority) {
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(this.priority);
            return thread;
        }
    }
}

