/*
 * Decompiled with CFR 0.152.
 */
package com.lzh.easythread;

import com.lzh.easythread.AsyncCallback;
import com.lzh.easythread.Callback;
import java.util.concurrent.Executor;

final class CallbackDelegate
implements Callback,
AsyncCallback {
    private Callback callback;
    private AsyncCallback async;
    private Executor deliver;

    CallbackDelegate(Callback callback, Executor deliver, AsyncCallback async) {
        this.callback = callback;
        this.deliver = deliver;
        this.async = async;
    }

    public void onSuccess(final Object o) {
        if (this.async == null) {
            return;
        }
        this.deliver.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CallbackDelegate.this.async.onSuccess(o);
                }
                catch (Throwable t) {
                    CallbackDelegate.this.onFailed(t);
                }
            }
        });
    }

    @Override
    public void onFailed(final Throwable t) {
        if (this.async == null) {
            return;
        }
        this.deliver.execute(new Runnable(){

            @Override
            public void run() {
                CallbackDelegate.this.async.onFailed(t);
            }
        });
    }

    @Override
    public void onError(final String name, final Throwable t) {
        this.onFailed(t);
        if (this.callback == null) {
            return;
        }
        this.deliver.execute(new Runnable(){

            @Override
            public void run() {
                CallbackDelegate.this.callback.onError(name, t);
            }
        });
    }

    @Override
    public void onCompleted(final String name) {
        if (this.callback == null) {
            return;
        }
        this.deliver.execute(new Runnable(){

            @Override
            public void run() {
                CallbackDelegate.this.callback.onCompleted(name);
            }
        });
    }

    @Override
    public void onStart(final String name) {
        if (this.callback == null) {
            return;
        }
        this.deliver.execute(new Runnable(){

            @Override
            public void run() {
                CallbackDelegate.this.callback.onStart(name);
            }
        });
    }
}

