/*
 * Decompiled with CFR 0.152.
 */
package com.lzh.easythread;

import com.lzh.easythread.AndroidMainExecutor;
import com.lzh.easythread.AsyncCallback;
import com.lzh.easythread.CallableWrapper;
import com.lzh.easythread.Callback;
import com.lzh.easythread.CallbackDelegate;
import com.lzh.easythread.NotSwitchExecutor;
import com.lzh.easythread.RunnableWrapper;
import com.lzh.easythread.Tools;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class EasyThread
implements Executor {
    private ExecutorService pool;
    private String defName;
    private Callback defCallback;
    private Executor defDeliver;
    private String name;
    private Callback callback;
    private long delay;
    private Executor deliver;

    private EasyThread(int type, int size, int priority, String name, Callback callback, Executor deliver) {
        this.pool = this.createPool(type, size, priority);
        this.defName = name;
        this.defCallback = callback;
        this.defDeliver = deliver;
    }

    public EasyThread name(String name) {
        this.name = name;
        return this;
    }

    public EasyThread callback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public EasyThread delay(long time, TimeUnit unit) {
        this.delay = unit.toMillis(time);
        return this;
    }

    public EasyThread deliver(Executor deliver) {
        this.deliver = deliver;
        return this;
    }

    @Override
    public void execute(Runnable runnable) {
        runnable = new RunnableWrapper(this.getName(), this.getCallback(null)).setRunnable(runnable);
        if (this.delay > 0L && this.pool instanceof ScheduledExecutorService) {
            ((ScheduledExecutorService)this.pool).schedule(runnable, this.delay, TimeUnit.MILLISECONDS);
        } else {
            this.pool.execute(runnable);
        }
        this.release();
    }

    public <T> void async(Callable<T> callable, AsyncCallback<T> callback) {
        RunnableWrapper runnable = new RunnableWrapper(this.getName(), this.getCallback(callback)).setCallable(callable);
        if (this.delay > 0L && this.pool instanceof ScheduledExecutorService) {
            ((ScheduledExecutorService)this.pool).schedule(runnable, this.delay, TimeUnit.MILLISECONDS);
        } else {
            this.pool.execute(runnable);
        }
        this.release();
    }

    public <T> Future<T> submit(Callable<T> callable) {
        callable = new CallableWrapper<T>(this.getName(), this.getCallback(null), callable);
        Future<T> result = this.delay > 0L && this.pool instanceof ScheduledExecutorService ? ((ScheduledExecutorService)this.pool).schedule(callable, this.delay, TimeUnit.MILLISECONDS) : this.pool.submit(callable);
        this.release();
        return result;
    }

    public ExecutorService getExecutor() {
        return this.pool;
    }

    private void release() {
        this.name = null;
        this.callback = null;
        this.delay = -1L;
        this.deliver = null;
    }

    private String getName() {
        return Tools.isEmpty(this.name) ? this.defName : this.name;
    }

    private CallbackDelegate getCallback(AsyncCallback async) {
        Callback used = this.callback == null ? this.defCallback : this.callback;
        Executor deliver = this.deliver == null ? this.defDeliver : this.deliver;
        return new CallbackDelegate(used, deliver, async);
    }

    private ExecutorService createPool(int type, int size, int priority) {
        switch (type) {
            case 0: {
                return Executors.newCachedThreadPool(new DefaultFactory(priority));
            }
            case 1: {
                return Executors.newFixedThreadPool(size, new DefaultFactory(priority));
            }
            case 3: {
                return Executors.newScheduledThreadPool(size, new DefaultFactory(priority));
            }
        }
        return Executors.newSingleThreadExecutor(new DefaultFactory(priority));
    }

    public static class Builder {
        static final int TYPE_CACHEABLE = 0;
        static final int TYPE_FIXED = 1;
        static final int TYPE_SINGLE = 2;
        static final int TYPE_SCHEDULED = 3;
        int type;
        int size;
        int priority = 5;
        String name;
        Callback callback;
        Executor deliver;

        private Builder(int size, int type) {
            this.size = Math.max(1, size);
            this.type = type;
        }

        public static Builder cacheable() {
            return new Builder(0, 0);
        }

        public static Builder fixed(int size) {
            return new Builder(size, 1);
        }

        public static Builder scheduled(int size) {
            return new Builder(size, 3);
        }

        public static Builder single() {
            return new Builder(0, 2);
        }

        public Builder name(String name) {
            if (!Tools.isEmpty(name)) {
                this.name = name;
            }
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder callback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public Builder deliver(Executor deliver) {
            this.deliver = deliver;
            return this;
        }

        public EasyThread build() {
            this.priority = Math.max(1, this.priority);
            this.priority = Math.min(10, this.priority);
            this.size = Math.max(0, this.size);
            if (Tools.isEmpty(this.name)) {
                switch (this.type) {
                    case 0: {
                        this.name = "CACHEABLE";
                        break;
                    }
                    case 1: {
                        this.name = "FIXED";
                        break;
                    }
                    case 2: {
                        this.name = "SINGLE";
                    }
                }
            }
            if (this.deliver == null) {
                this.deliver = Tools.isAndroid ? AndroidMainExecutor.getInstance() : NotSwitchExecutor.getInstance();
            }
            return new EasyThread(this.type, this.size, this.priority, this.name, this.callback, this.deliver);
        }
    }

    private static class DefaultFactory
    implements ThreadFactory {
        private int priority;

        DefaultFactory(int priority) {
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(this.priority);
            return thread;
        }
    }
}

