/*
 * Decompiled with CFR 0.152.
 */
package com.gh.net_lib.subscribers;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import com.gh.net_lib.api.BaseApi;
import com.gh.net_lib.api.BaseResultEntity;
import com.gh.net_lib.exception.HttpTimeException;
import com.gh.net_lib.listener.BaseHttpOnNextListener;
import io.reactivex.subscribers.DisposableSubscriber;
import java.lang.ref.SoftReference;

public class ProgressSubscriber<T extends BaseResultEntity>
extends DisposableSubscriber<T> {
    private boolean showPorgress = true;
    private SoftReference<BaseHttpOnNextListener> mSubscriberOnNextListener;
    private SoftReference<Context> contextSoftReference;
    private Dialog pd;
    private BaseApi api;

    public ProgressSubscriber(BaseApi api) {
        this.api = api;
        this.mSubscriberOnNextListener = api.getListener();
        this.contextSoftReference = new SoftReference<Context>(api.getContext());
        this.setShowPorgress(api.isShowProgress());
        if (api.isShowProgress()) {
            this.initProgressDialog(api.isCancel());
        }
    }

    protected void onStart() {
        super.onStart();
        this.mSubscriberOnNextListener.get().onLoading();
        this.showProgressDialog();
    }

    public void onNext(T t) {
        if (this.mSubscriberOnNextListener.get() != null) {
            if (t.isSuccess()) {
                this.mSubscriberOnNextListener.get().onNext(t.getData());
            } else {
                this.mSubscriberOnNextListener.get().onError(new HttpTimeException(t.getMsg()));
                this.mSubscriberOnNextListener.get().onError(new HttpTimeException(t.getMsg()), t.getCode(), t.getMsg(), t.getData());
            }
        }
    }

    public void onError(Throwable t) {
        this.mSubscriberOnNextListener.get().onLoadFinish();
        this.dismissProgressDialog();
        this.errorDo(t);
    }

    public void onComplete() {
        this.mSubscriberOnNextListener.get().onLoadFinish();
        this.dismissProgressDialog();
    }

    private void initProgressDialog(boolean cancel) {
        Context context = this.contextSoftReference.get();
        if (this.pd == null && this.api != null) {
            this.pd = this.api.getProgressDialog();
            this.pd.setCancelable(cancel);
            if (cancel) {
                this.pd.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        if (ProgressSubscriber.this.mSubscriberOnNextListener.get() != null) {
                            ((BaseHttpOnNextListener)ProgressSubscriber.this.mSubscriberOnNextListener.get()).onCancel();
                        }
                        ProgressSubscriber.this.onCancelProgress();
                    }
                });
            }
        }
    }

    private void showProgressDialog() {
        if (!this.isShowPorgress()) {
            return;
        }
        Context context = this.contextSoftReference.get();
        if (this.pd == null || context == null) {
            return;
        }
        if (!this.pd.isShowing()) {
            try {
                this.pd.show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void dismissProgressDialog() {
        if (!this.isShowPorgress()) {
            return;
        }
        if (this.pd != null && this.pd.isShowing()) {
            try {
                this.pd.dismiss();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void errorDo(Throwable e) {
        Context context = this.contextSoftReference.get();
        if (context == null) {
            return;
        }
        if (this.mSubscriberOnNextListener.get() != null) {
            this.mSubscriberOnNextListener.get().onError(e);
            this.mSubscriberOnNextListener.get().onError(e, null, null, null);
        }
    }

    public void onCancelProgress() {
        if (!this.isDisposed()) {
            this.dispose();
        }
    }

    public boolean isShowPorgress() {
        return this.showPorgress;
    }

    public void setShowPorgress(boolean showPorgress) {
        this.showPorgress = showPorgress;
    }
}

