/*
 * Decompiled with CFR 0.152.
 */
package com.gh.net_lib.api;

import android.app.Dialog;
import android.content.Context;
import com.gh.net_lib.LoadingDialog;
import com.gh.net_lib.api.BaseResultEntity;
import com.gh.net_lib.exception.HttpTimeException;
import com.gh.net_lib.listener.BaseHttpOnNextListener;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.lang.ref.SoftReference;
import retrofit2.Retrofit;

public abstract class BaseApi<T>
implements Function<BaseResultEntity<T>, BaseResultEntity<T>> {
    private SoftReference<Context> contextSoftReference;
    private SoftReference<BaseHttpOnNextListener> listener;
    private Dialog progressDialog;
    private boolean cancel;
    private boolean showProgress;
    private String baseUrl = "https://www.izaodao.com/Api/";
    private int connectionTime = 6;
    private int retryCount = 0;
    private long retryDelay = 100L;
    private long retryIncreaseDelay = 10L;

    public BaseApi(Context context, BaseHttpOnNextListener listener) {
        this.setListener(listener);
        this.setContext(context);
        this.setProgressDialog((Dialog)new LoadingDialog(context));
        this.setShowProgress(true);
    }

    public abstract Flowable getObservable(Retrofit var1);

    public int getConnectionTime() {
        return this.connectionTime;
    }

    public void setConnectionTime(int connectionTime) {
        this.connectionTime = connectionTime;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setContext(Context context) {
        this.contextSoftReference = new SoftReference<Context>(context);
    }

    public Dialog getProgressDialog() {
        return this.progressDialog;
    }

    public void setProgressDialog(Dialog progressDialog) {
        this.progressDialog = progressDialog;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public SoftReference<BaseHttpOnNextListener> getListener() {
        return this.listener;
    }

    public void setListener(BaseHttpOnNextListener listener) {
        this.listener = new SoftReference<BaseHttpOnNextListener>(listener);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public long getRetryIncreaseDelay() {
        return this.retryIncreaseDelay;
    }

    public void setRetryIncreaseDelay(long retryIncreaseDelay) {
        this.retryIncreaseDelay = retryIncreaseDelay;
    }

    public Context getContext() {
        return this.contextSoftReference.get();
    }

    public BaseResultEntity<T> apply(BaseResultEntity<T> httpResult) {
        if (!httpResult.isSuccess()) {
            throw new HttpTimeException(httpResult.getMsg());
        }
        return httpResult;
    }
}

