/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.animation;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.util.Log;
import android.util.Property;
import android.view.animation.Interpolator;
import com.github.ybq.android.spinkit.animation.interpolator.KeyFrameInterpolator;
import com.github.ybq.android.spinkit.sprite.Sprite;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SpriteAnimatorBuilder {
    private static final String TAG = "SpriteAnimatorBuilder";
    private Sprite sprite;
    private Interpolator interpolator;
    private int repeatCount = -1;
    private long duration = 2000L;
    private int startFrame = 0;
    private Map<String, FrameData> fds = new HashMap<String, FrameData>();

    public SpriteAnimatorBuilder(Sprite sprite) {
        this.sprite = sprite;
    }

    public SpriteAnimatorBuilder scale(float[] fractions, Float ... scale) {
        this.holder(fractions, Sprite.SCALE, scale);
        return this;
    }

    public SpriteAnimatorBuilder alpha(float[] fractions, Integer ... alpha) {
        this.holder(fractions, Sprite.ALPHA, alpha);
        return this;
    }

    public SpriteAnimatorBuilder scaleX(float[] fractions, Float ... scaleX) {
        this.holder(fractions, Sprite.SCALE, scaleX);
        return this;
    }

    public SpriteAnimatorBuilder scaleY(float[] fractions, Float ... scaleY) {
        this.holder(fractions, Sprite.SCALE_Y, scaleY);
        return this;
    }

    public SpriteAnimatorBuilder rotateX(float[] fractions, Integer ... rotateX) {
        this.holder(fractions, Sprite.ROTATE_X, rotateX);
        return this;
    }

    public SpriteAnimatorBuilder rotateY(float[] fractions, Integer ... rotateY) {
        this.holder(fractions, Sprite.ROTATE_Y, rotateY);
        return this;
    }

    public SpriteAnimatorBuilder translateX(float[] fractions, Integer ... translateX) {
        this.holder(fractions, Sprite.TRANSLATE_X, translateX);
        return this;
    }

    public SpriteAnimatorBuilder translateY(float[] fractions, Integer ... translateY) {
        this.holder(fractions, Sprite.TRANSLATE_Y, translateY);
        return this;
    }

    public SpriteAnimatorBuilder rotate(float[] fractions, Integer ... rotate) {
        this.holder(fractions, Sprite.ROTATE, rotate);
        return this;
    }

    public SpriteAnimatorBuilder translateXPercentage(float[] fractions, Float ... translateXPercentage) {
        this.holder(fractions, Sprite.TRANSLATE_X_PERCENTAGE, translateXPercentage);
        return this;
    }

    public SpriteAnimatorBuilder translateYPercentage(float[] fractions, Float ... translateYPercentage) {
        this.holder(fractions, Sprite.TRANSLATE_Y_PERCENTAGE, translateYPercentage);
        return this;
    }

    private void holder(float[] fractions, Property property, Float[] values) {
        this.ensurePair(fractions.length, values.length);
        this.fds.put(property.getName(), new FloatFrameData(fractions, property, values));
    }

    private void holder(float[] fractions, Property property, Integer[] values) {
        this.ensurePair(fractions.length, values.length);
        this.fds.put(property.getName(), new IntFrameData(fractions, property, values));
    }

    private void ensurePair(int fractionsLength, int valuesLength) {
        if (fractionsLength != valuesLength) {
            throw new IllegalStateException(String.format(Locale.getDefault(), "The fractions.length must equal values.length, fraction.length[%d], values.length[%d]", fractionsLength, valuesLength));
        }
    }

    public SpriteAnimatorBuilder interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    public SpriteAnimatorBuilder easeInOut(float ... fractions) {
        this.interpolator(KeyFrameInterpolator.easeInOut(fractions));
        return this;
    }

    public SpriteAnimatorBuilder duration(long duration) {
        this.duration = duration;
        return this;
    }

    public SpriteAnimatorBuilder repeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
        return this;
    }

    public SpriteAnimatorBuilder startFrame(int startFrame) {
        if (startFrame < 0) {
            Log.w((String)TAG, (String)"startFrame should always be non-negative");
            startFrame = 0;
        }
        this.startFrame = startFrame;
        return this;
    }

    public ObjectAnimator build() {
        PropertyValuesHolder[] holders = new PropertyValuesHolder[this.fds.size()];
        int i = 0;
        for (Map.Entry<String, FrameData> fd : this.fds.entrySet()) {
            FrameData data = fd.getValue();
            Keyframe[] keyframes = new Keyframe[data.fractions.length];
            float[] fractions = data.fractions;
            float startF = fractions[this.startFrame];
            for (int j = this.startFrame; j < this.startFrame + data.values.length; ++j) {
                int key = j - this.startFrame;
                int vk = j % data.values.length;
                float fraction = fractions[vk] - startF;
                if (fraction < 0.0f) {
                    fraction = fractions[fractions.length - 1] + fraction;
                }
                keyframes[key] = data instanceof IntFrameData ? Keyframe.ofInt((float)fraction, (int)((Integer)data.values[vk])) : (data instanceof FloatFrameData ? Keyframe.ofFloat((float)fraction, (float)((Float)data.values[vk]).floatValue()) : Keyframe.ofObject((float)fraction, data.values[vk]));
            }
            holders[i] = PropertyValuesHolder.ofKeyframe((Property)data.property, (Keyframe[])keyframes);
            ++i;
        }
        ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this.sprite), (PropertyValuesHolder[])holders);
        animator.setDuration(this.duration);
        animator.setRepeatCount(this.repeatCount);
        animator.setInterpolator((TimeInterpolator)this.interpolator);
        return animator;
    }

    class FloatFrameData
    extends FrameData<Float> {
        public FloatFrameData(float[] fractions, Property property, Float[] values) {
            super(fractions, property, values);
        }
    }

    class IntFrameData
    extends FrameData<Integer> {
        public IntFrameData(float[] fractions, Property property, Integer[] values) {
            super(fractions, property, values);
        }
    }

    class FrameData<T> {
        float[] fractions;
        Property property;
        T[] values;

        public FrameData(float[] fractions, Property property, T[] values) {
            this.fractions = fractions;
            this.property = property;
            this.values = values;
        }
    }
}

