/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.style;

import android.animation.ValueAnimator;
import android.graphics.Rect;
import com.github.ybq.android.spinkit.animation.SpriteAnimatorBuilder;
import com.github.ybq.android.spinkit.sprite.RectSprite;
import com.github.ybq.android.spinkit.sprite.Sprite;
import com.github.ybq.android.spinkit.sprite.SpriteContainer;

public class CubeGrid
extends SpriteContainer {
    @Override
    public Sprite[] onCreateChild() {
        int[] delays = new int[]{200, 300, 400, 100, 200, 300, 0, 100, 200};
        Sprite[] gridItems = new GridItem[9];
        for (int i = 0; i < gridItems.length; ++i) {
            gridItems[i] = new GridItem();
            gridItems[i].setAnimationDelay(delays[i]);
        }
        return gridItems;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        bounds = this.clipSquare(bounds);
        int width = (int)((float)bounds.width() * 0.33f);
        int height = (int)((float)bounds.height() * 0.33f);
        for (int i = 0; i < this.getChildCount(); ++i) {
            int x = i % 3;
            int y = i / 3;
            int l = bounds.left + x * width;
            int t = bounds.top + y * height;
            Sprite sprite = this.getChildAt(i);
            sprite.setDrawBounds(l, t, l + width, t + height);
        }
    }

    private class GridItem
    extends RectSprite {
        private GridItem() {
        }

        @Override
        public ValueAnimator onCreateAnimation() {
            float[] fractions = new float[]{0.0f, 0.35f, 0.7f, 1.0f};
            return new SpriteAnimatorBuilder(this).scale(fractions, Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)).duration(1300L).easeInOut(fractions).build();
        }
    }
}

