/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.animation.interpolator;

import android.animation.TimeInterpolator;
import android.view.animation.Interpolator;
import com.github.ybq.android.spinkit.animation.interpolator.Ease;
import com.github.ybq.android.spinkit.animation.interpolator.PathInterpolatorCompat;

public class KeyFrameInterpolator
implements Interpolator {
    private TimeInterpolator interpolator;
    private float[] fractions;

    public static KeyFrameInterpolator easeInOut(float ... fractions) {
        KeyFrameInterpolator interpolator = new KeyFrameInterpolator((TimeInterpolator)Ease.inOut(), new float[0]);
        interpolator.setFractions(fractions);
        return interpolator;
    }

    public static KeyFrameInterpolator pathInterpolator(float controlX1, float controlY1, float controlX2, float controlY2, float ... fractions) {
        KeyFrameInterpolator interpolator = new KeyFrameInterpolator((TimeInterpolator)PathInterpolatorCompat.create(controlX1, controlY1, controlX2, controlY2), new float[0]);
        interpolator.setFractions(fractions);
        return interpolator;
    }

    public KeyFrameInterpolator(TimeInterpolator interpolator, float ... fractions) {
        this.interpolator = interpolator;
        this.fractions = fractions;
    }

    public void setFractions(float ... fractions) {
        this.fractions = fractions;
    }

    public synchronized float getInterpolation(float input) {
        if (this.fractions.length > 1) {
            for (int i = 0; i < this.fractions.length - 1; ++i) {
                float start = this.fractions[i];
                float end = this.fractions[i + 1];
                float duration = end - start;
                if (!(input >= start) || !(input <= end)) continue;
                input = (input - start) / duration;
                return start + this.interpolator.getInterpolation(input) * duration;
            }
        }
        return this.interpolator.getInterpolation(input);
    }
}

