/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.sprite;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import com.github.ybq.android.spinkit.sprite.Sprite;

public abstract class ShapeSprite
extends Sprite {
    private Paint mPaint;
    private int mUseColor;
    private int mBaseColor;

    public ShapeSprite() {
        this.setColor(-1);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mUseColor);
    }

    @Override
    public void setColor(int color) {
        this.mBaseColor = color;
        this.updateUseColor();
    }

    @Override
    public int getColor() {
        return this.mBaseColor;
    }

    public int getUseColor() {
        return this.mUseColor;
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        this.updateUseColor();
    }

    private void updateUseColor() {
        int alpha = this.getAlpha();
        alpha += alpha >> 7;
        int baseAlpha = this.mBaseColor >>> 24;
        int useAlpha = baseAlpha * alpha >> 8;
        this.mUseColor = this.mBaseColor << 8 >>> 8 | useAlpha << 24;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    @Override
    protected final void drawSelf(Canvas canvas) {
        this.mPaint.setColor(this.mUseColor);
        this.drawShape(canvas, this.mPaint);
    }

    public abstract void drawShape(Canvas var1, Paint var2);
}

