/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.animation;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.util.Property;
import android.view.animation.Interpolator;
import com.github.ybq.android.spinkit.animation.interpolator.KeyFrameInterpolator;
import com.github.ybq.android.spinkit.sprite.Sprite;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SpriteAnimatorBuilder {
    private Sprite sprite;
    private List<PropertyValuesHolder> propertyValuesHolders = new ArrayList<PropertyValuesHolder>();
    private Interpolator interpolator;
    private int repeatCount = -1;
    private long duration = 2000L;

    public SpriteAnimatorBuilder(Sprite sprite) {
        this.sprite = sprite;
    }

    public SpriteAnimatorBuilder scale(float[] fractions, float ... scale) {
        this.holder(fractions, Sprite.SCALE, scale);
        return this;
    }

    public SpriteAnimatorBuilder alpha(float[] fractions, int ... alpha) {
        this.holder(fractions, Sprite.ALPHA, alpha);
        return this;
    }

    public SpriteAnimatorBuilder scaleX(float[] fractions, float ... scaleX) {
        this.holder(fractions, Sprite.SCALE, scaleX);
        return this;
    }

    public SpriteAnimatorBuilder scaleY(float[] fractions, float ... scaleY) {
        this.holder(fractions, Sprite.SCALE_Y, scaleY);
        return this;
    }

    public SpriteAnimatorBuilder rotateX(float[] fractions, int ... rotateX) {
        this.holder(fractions, Sprite.ROTATE_X, rotateX);
        return this;
    }

    public SpriteAnimatorBuilder rotateY(float[] fractions, int ... rotateY) {
        this.holder(fractions, Sprite.ROTATE_Y, rotateY);
        return this;
    }

    public SpriteAnimatorBuilder translateX(float[] fractions, int ... translateX) {
        this.holder(fractions, Sprite.TRANSLATE_X, translateX);
        return this;
    }

    public SpriteAnimatorBuilder translateY(float[] fractions, int ... translateY) {
        this.holder(fractions, Sprite.TRANSLATE_Y, translateY);
        return this;
    }

    public SpriteAnimatorBuilder rotate(float[] fractions, int ... rotate) {
        this.holder(fractions, Sprite.ROTATE, rotate);
        return this;
    }

    public SpriteAnimatorBuilder translateXPercentage(float[] fractions, float ... translateXPercentage) {
        this.holder(fractions, Sprite.TRANSLATE_X_PERCENTAGE, translateXPercentage);
        return this;
    }

    public SpriteAnimatorBuilder translateYPercentage(float[] fractions, float ... translateYPercentage) {
        this.holder(fractions, Sprite.TRANSLATE_Y_PERCENTAGE, translateYPercentage);
        return this;
    }

    public PropertyValuesHolder holder(float[] fractions, Property property, float[] values) {
        this.ensurePair(fractions.length, values.length);
        Keyframe[] keyframes = new Keyframe[fractions.length];
        for (int i = 0; i < values.length; ++i) {
            keyframes[i] = Keyframe.ofFloat((float)fractions[i], (float)values[i]);
        }
        PropertyValuesHolder valuesHolder = PropertyValuesHolder.ofKeyframe((Property)property, (Keyframe[])keyframes);
        this.propertyValuesHolders.add(valuesHolder);
        return valuesHolder;
    }

    public PropertyValuesHolder holder(float[] fractions, Property property, int[] values) {
        this.ensurePair(fractions.length, values.length);
        Keyframe[] keyframes = new Keyframe[fractions.length];
        for (int i = 0; i < values.length; ++i) {
            keyframes[i] = Keyframe.ofInt((float)fractions[i], (int)values[i]);
        }
        PropertyValuesHolder valuesHolder = PropertyValuesHolder.ofKeyframe((Property)property, (Keyframe[])keyframes);
        this.propertyValuesHolders.add(valuesHolder);
        return valuesHolder;
    }

    private void ensurePair(int fractionsLength, int valuesLength) {
        if (fractionsLength != valuesLength) {
            throw new IllegalStateException(String.format(Locale.getDefault(), "The fractions.length must equal values.length, fraction.length[%d], values.length[%d]", fractionsLength, valuesLength));
        }
    }

    public SpriteAnimatorBuilder interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    public SpriteAnimatorBuilder easeInOut(float ... fractions) {
        this.interpolator(KeyFrameInterpolator.easeInOut(fractions));
        return this;
    }

    public SpriteAnimatorBuilder duration(long duration) {
        this.duration = duration;
        return this;
    }

    public SpriteAnimatorBuilder repeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
        return this;
    }

    public ObjectAnimator build() {
        PropertyValuesHolder[] holders = new PropertyValuesHolder[this.propertyValuesHolders.size()];
        ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this.sprite), (PropertyValuesHolder[])this.propertyValuesHolders.toArray(holders));
        animator.setDuration(this.duration);
        animator.setRepeatCount(this.repeatCount);
        animator.setInterpolator((TimeInterpolator)this.interpolator);
        return animator;
    }
}

