/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import com.github.ybq.android.library.R;
import com.github.ybq.android.spinkit.Style;
import com.github.ybq.android.spinkit.sprite.Sprite;
import com.github.ybq.android.spinkit.style.ChasingDots;
import com.github.ybq.android.spinkit.style.Circle;
import com.github.ybq.android.spinkit.style.CubeGrid;
import com.github.ybq.android.spinkit.style.DoubleBounce;
import com.github.ybq.android.spinkit.style.FadingCircle;
import com.github.ybq.android.spinkit.style.FoldingCube;
import com.github.ybq.android.spinkit.style.Pulse;
import com.github.ybq.android.spinkit.style.RotatingPlane;
import com.github.ybq.android.spinkit.style.ThreeBounce;
import com.github.ybq.android.spinkit.style.WanderingCubes;

public class SpinKitView
extends ProgressBar {
    private Style mStyle;
    private int mColor;
    private Sprite mSprite;

    public SpinKitView(Context context) {
        this(context, null);
    }

    public SpinKitView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.SpinKitViewStyle);
    }

    public SpinKitView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.SpinKitView);
    }

    @TargetApi(value=21)
    public SpinKitView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SpinKitView, defStyleAttr, defStyleRes);
        this.mStyle = Style.values()[a.getInt(R.styleable.SpinKitView_SpinKit_Style, 0)];
        this.mColor = a.getColor(R.styleable.SpinKitView_SpinKit_Color, -1);
        a.recycle();
        this.init();
        this.setIndeterminate(true);
    }

    private void init() {
        switch (this.mStyle) {
            case ROTATING_PLANE: {
                this.setIndeterminateDrawable(new RotatingPlane());
                break;
            }
            case DOUBLE_BOUNCE: {
                this.setIndeterminateDrawable(new DoubleBounce());
                break;
            }
            case WAVE: {
                this.setIndeterminateDrawable(new RotatingPlane());
                break;
            }
            case WANDERING_CUBES: {
                this.setIndeterminateDrawable(new WanderingCubes());
                break;
            }
            case PULSE: {
                this.setIndeterminateDrawable(new Pulse());
                break;
            }
            case CHASING_DOTS: {
                this.setIndeterminateDrawable(new ChasingDots());
                break;
            }
            case THREE_BOUNCE: {
                this.setIndeterminateDrawable(new ThreeBounce());
                break;
            }
            case CIRCLE: {
                this.setIndeterminateDrawable(new Circle());
                break;
            }
            case CUBE_GRID: {
                this.setIndeterminateDrawable(new CubeGrid());
                break;
            }
            case FADING_CIRCLE: {
                this.setIndeterminateDrawable(new FadingCircle());
                break;
            }
            case FOLDING_CUBE: {
                this.setIndeterminateDrawable(new FoldingCube());
                break;
            }
        }
    }

    public void setIndeterminateDrawable(Drawable d) {
        super.setIndeterminateDrawable(d);
        if (!(d instanceof Sprite)) {
            throw new IllegalArgumentException();
        }
        this.setIndeterminateDrawable((Sprite)d);
    }

    public void setIndeterminateDrawable(Sprite d) {
        super.setIndeterminateDrawable((Drawable)d);
        this.mSprite = d;
        this.mSprite.setColor(this.mColor);
    }

    public Sprite getIndeterminateDrawable() {
        return this.mSprite;
    }

    public void setIndeterminateDrawableTiled(Drawable d) {
        super.setIndeterminateDrawableTiled(d);
    }
}

