/*
 * Decompiled with CFR 0.152.
 */
package com.yausername.youtubedl_android;

import android.content.Context;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.yausername.youtubedl_android.YoutubeDL;
import com.yausername.youtubedl_android.YoutubeDLException;
import com.yausername.youtubedl_common.SharedPrefsHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J!\u0010\u0017\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/yausername/youtubedl_android/YoutubeDLUpdater;", "", "()V", "dlpBinaryName", "", "dlpVersionKey", "dlpVersionNameKey", "youtubeDLNightlyChannelUrl", "youtubeDLStableChannelUrl", "checkForUpdate", "Lcom/fasterxml/jackson/databind/JsonNode;", "appContext", "Landroid/content/Context;", "youtubeDLChannel", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel;", "download", "Ljava/io/File;", "url", "getDownloadUrl", "json", "getName", "getTag", "getYoutubeDLDir", "update", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateStatus;", "update$library_release", "updateSharedPrefs", "", "tag", "name", "version", "versionName", "library_release"})
public final class YoutubeDLUpdater {
    @NotNull
    public static final YoutubeDLUpdater INSTANCE = new YoutubeDLUpdater();
    @NotNull
    private static final String youtubeDLStableChannelUrl = "https://api.github.com/repos/yt-dlp/yt-dlp/releases/latest";
    @NotNull
    private static final String youtubeDLNightlyChannelUrl = "https://api.github.com/repos/yt-dlp/yt-dlp-nightly-builds/releases/latest";
    @NotNull
    private static final String dlpBinaryName = "yt-dlp";
    @NotNull
    private static final String dlpVersionKey = "dlpVersion";
    @NotNull
    private static final String dlpVersionNameKey = "dlpVersionName";

    private YoutubeDLUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final YoutubeDL.UpdateStatus update$library_release(@Nullable Context appContext, @NotNull YoutubeDL.UpdateChannel youtubeDLChannel) throws IOException, YoutubeDLException {
        Intrinsics.checkNotNullParameter((Object)youtubeDLChannel, (String)"youtubeDLChannel");
        Context context = appContext;
        Intrinsics.checkNotNull((Object)context);
        JsonNode jsonNode = this.checkForUpdate(context, youtubeDLChannel);
        if (jsonNode == null) {
            return YoutubeDL.UpdateStatus.ALREADY_UP_TO_DATE;
        }
        JsonNode json = jsonNode;
        String downloadUrl = this.getDownloadUrl(json);
        File file = this.download(appContext, downloadUrl);
        File ytdlpDir = this.getYoutubeDLDir(appContext);
        File binary = new File(ytdlpDir, dlpBinaryName);
        try {
            if (ytdlpDir.exists()) {
                FileUtils.deleteDirectory((File)ytdlpDir);
            }
            ytdlpDir.mkdirs();
            FileUtils.copyFile((File)file, (File)binary);
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)ytdlpDir);
            YoutubeDL.getInstance().init_ytdlp(appContext, ytdlpDir);
            throw new YoutubeDLException(e);
        }
        finally {
            file.delete();
        }
        this.updateSharedPrefs(appContext, this.getTag(json), this.getName(json));
        return YoutubeDL.UpdateStatus.DONE;
    }

    public static /* synthetic */ YoutubeDL.UpdateStatus update$library_release$default(YoutubeDLUpdater youtubeDLUpdater, Context context, YoutubeDL.UpdateChannel updateChannel, int n, Object object) throws IOException, YoutubeDLException {
        if ((n & 2) != 0) {
            updateChannel = YoutubeDL.UpdateChannel.STABLE.INSTANCE;
        }
        return youtubeDLUpdater.update$library_release(context, updateChannel);
    }

    private final void updateSharedPrefs(Context appContext, String tag, String name) {
        SharedPrefsHelper.update((Context)appContext, (String)dlpVersionKey, (String)tag);
        SharedPrefsHelper.update((Context)appContext, (String)dlpVersionNameKey, (String)name);
    }

    private final JsonNode checkForUpdate(Context appContext, YoutubeDL.UpdateChannel youtubeDLChannel) throws IOException {
        URL url = new URL(youtubeDLChannel.getApiUrl());
        JsonNode json = YoutubeDL.INSTANCE.getObjectMapper().readTree(url);
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String newVersion = this.getTag(json);
        String oldVersion = SharedPrefsHelper.get((Context)appContext, (String)dlpVersionKey);
        return Intrinsics.areEqual((Object)newVersion, (Object)oldVersion) ? null : json;
    }

    private final String getTag(JsonNode json) {
        String string = json.get("tag_name").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json[\"tag_name\"].asText()");
        return string;
    }

    private final String getName(JsonNode json) {
        String string = json.get("name").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json[\"name\"].asText()");
        return string;
    }

    private final String getDownloadUrl(JsonNode json) throws YoutubeDLException {
        JsonNode jsonNode = json.get("assets");
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
        ArrayNode assets = (ArrayNode)jsonNode;
        String downloadUrl = "";
        for (JsonNode asset : assets) {
            if (!Intrinsics.areEqual((Object)dlpBinaryName, (Object)asset.get("name").asText())) continue;
            String string = asset.get("browser_download_url").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asset[\"browser_download_url\"].asText()");
            downloadUrl = string;
            break;
        }
        if (((CharSequence)downloadUrl).length() == 0) {
            throw new YoutubeDLException("unable to get download url");
        }
        return downloadUrl;
    }

    private final File download(Context appContext, String url) throws IOException {
        URL downloadUrl = new URL(url);
        File file = File.createTempFile(dlpBinaryName, null, appContext.getCacheDir());
        FileUtils.copyURLToFile((URL)downloadUrl, (File)file, (int)5000, (int)10000);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return file;
    }

    private final File getYoutubeDLDir(Context appContext) {
        File baseDir = new File(appContext.getNoBackupFilesDir(), "youtubedl-android");
        return new File(baseDir, dlpBinaryName);
    }

    @Nullable
    public final String version(@Nullable Context appContext) {
        Context context = appContext;
        Intrinsics.checkNotNull((Object)context);
        return SharedPrefsHelper.get((Context)context, (String)dlpVersionKey);
    }

    @Nullable
    public final String versionName(@Nullable Context appContext) {
        Context context = appContext;
        Intrinsics.checkNotNull((Object)context);
        return SharedPrefsHelper.get((Context)context, (String)dlpVersionNameKey);
    }
}

