/*
 * Decompiled with CFR 0.152.
 */
package com.yausername.youtubedl_android;

import android.content.Context;
import android.os.Build;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yausername.youtubedl_android.R;
import com.yausername.youtubedl_android.StreamGobbler;
import com.yausername.youtubedl_android.StreamProcessExtractor;
import com.yausername.youtubedl_android.YoutubeDLException;
import com.yausername.youtubedl_android.YoutubeDLRequest;
import com.yausername.youtubedl_android.YoutubeDLResponse;
import com.yausername.youtubedl_android.YoutubeDLUpdater;
import com.yausername.youtubedl_android.mapper.VideoInfo;
import com.yausername.youtubedl_common.SharedPrefsHelper;
import com.yausername.youtubedl_common.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003DEFB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0004J@\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00042\"\b\u0002\u0010+\u001a\u001c\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#\u0018\u00010,H\u0007J\u000e\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020)J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0004J\b\u00102\u001a\u00020\u0000H\u0007J\u0018\u00103\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u0006\u00104\u001a\u00020\u0004H\u0002J\u000e\u00105\u001a\u00020#2\u0006\u00106\u001a\u000207J\u0016\u00108\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u00109\u001a\u00020\nJ\u0016\u0010:\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u0010;\u001a\u00020\nJ\u0018\u0010<\u001a\u00020\u00142\u0006\u00106\u001a\u0002072\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0018\u0010>\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u0010=\u001a\u00020\u0004H\u0002J\u001a\u0010?\u001a\u0004\u0018\u00010@2\u0006\u00106\u001a\u0002072\b\b\u0002\u0010A\u001a\u00020BJ\u0012\u0010=\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u000107J\u0012\u0010C\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u000107R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\u000e\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u0011 \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/yausername/youtubedl_android/YoutubeDL;", "", "()V", "ENV_LD_LIBRARY_PATH", "", "ENV_PYTHONHOME", "ENV_SSL_CERT_FILE", "aria2cDirName", "baseName", "binDir", "Ljava/io/File;", "ffmpegBinName", "ffmpegDirName", "ffmpegPath", "idProcessMap", "", "kotlin.jvm.PlatformType", "Ljava/lang/Process;", "", "initialized", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "packagesRoot", "pythonBinName", "pythonDirName", "pythonLibName", "pythonLibVersion", "pythonPath", "ytdlpBin", "ytdlpDirName", "ytdlpPath", "assertInit", "", "destroyProcessById", "id", "execute", "Lcom/yausername/youtubedl_android/YoutubeDLResponse;", "request", "Lcom/yausername/youtubedl_android/YoutubeDLRequest;", "processId", "callback", "Lkotlin/Function3;", "", "", "getInfo", "Lcom/yausername/youtubedl_android/mapper/VideoInfo;", "url", "getInstance", "ignoreErrors", "out", "init", "appContext", "Landroid/content/Context;", "initPython", "pythonDir", "init_ytdlp", "ytdlpDir", "shouldUpdatePython", "version", "updatePython", "updateYoutubeDL", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateStatus;", "updateChannel", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel;", "versionName", "CanceledException", "UpdateChannel", "UpdateStatus", "library_release"})
public final class YoutubeDL {
    @NotNull
    public static final YoutubeDL INSTANCE = new YoutubeDL();
    private static boolean initialized;
    @Nullable
    private static File pythonPath;
    @Nullable
    private static File ffmpegPath;
    @Nullable
    private static File ytdlpPath;
    @Nullable
    private static File binDir;
    @Nullable
    private static String ENV_LD_LIBRARY_PATH;
    @Nullable
    private static String ENV_SSL_CERT_FILE;
    @Nullable
    private static String ENV_PYTHONHOME;
    private static final Map<String, Process> idProcessMap;
    @NotNull
    public static final String baseName = "youtubedl-android";
    @NotNull
    private static final String packagesRoot = "packages";
    @NotNull
    private static final String pythonBinName = "libpython.so";
    @NotNull
    private static final String pythonLibName = "libpython.zip.so";
    @NotNull
    private static final String pythonDirName = "python";
    @NotNull
    private static final String ffmpegDirName = "ffmpeg";
    @NotNull
    private static final String ffmpegBinName = "libffmpeg.so";
    @NotNull
    private static final String aria2cDirName = "aria2c";
    @NotNull
    public static final String ytdlpDirName = "yt-dlp";
    @NotNull
    public static final String ytdlpBin = "yt-dlp";
    @NotNull
    private static final String pythonLibVersion = "pythonLibVersion";
    @NotNull
    private static final ObjectMapper objectMapper;

    private YoutubeDL() {
    }

    public final synchronized void init(@NotNull Context appContext) throws YoutubeDLException {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        if (initialized) {
            return;
        }
        File baseDir = new File(appContext.getNoBackupFilesDir(), baseName);
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
        File packagesDir = new File(baseDir, packagesRoot);
        binDir = new File(appContext.getApplicationInfo().nativeLibraryDir);
        pythonPath = new File(binDir, pythonBinName);
        ffmpegPath = new File(binDir, ffmpegBinName);
        File pythonDir = new File(packagesDir, pythonDirName);
        File ffmpegDir = new File(packagesDir, ffmpegDirName);
        File aria2cDir = new File(packagesDir, aria2cDirName);
        File ytdlpDir = new File(baseDir, "yt-dlp");
        ytdlpPath = new File(ytdlpDir, "yt-dlp");
        ENV_LD_LIBRARY_PATH = pythonDir.getAbsolutePath() + "/usr/lib:" + ffmpegDir.getAbsolutePath() + "/usr/lib:" + aria2cDir.getAbsolutePath() + "/usr/lib";
        ENV_SSL_CERT_FILE = pythonDir.getAbsolutePath() + "/usr/etc/tls/cert.pem";
        ENV_PYTHONHOME = pythonDir.getAbsolutePath() + "/usr";
        this.initPython(appContext, pythonDir);
        this.init_ytdlp(appContext, ytdlpDir);
        initialized = true;
    }

    public final void init_ytdlp(@NotNull Context appContext, @NotNull File ytdlpDir) throws YoutubeDLException {
        File ytdlpBinary;
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)ytdlpDir, (String)"ytdlpDir");
        if (!ytdlpDir.exists()) {
            ytdlpDir.mkdirs();
        }
        if (!(ytdlpBinary = new File(ytdlpDir, "yt-dlp")).exists()) {
            try {
                InputStream inputStream = appContext.getResources().openRawResource(R.raw.ytdlp);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"appContext.resources.openRawResource(R.raw.ytdlp)");
                InputStream inputStream2 = inputStream;
                FileUtils.copyInputStreamToFile((InputStream)inputStream2, (File)ytdlpBinary);
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)ytdlpDir);
                throw new YoutubeDLException("failed to initialize", e);
            }
        }
    }

    public final void initPython(@NotNull Context appContext, @NotNull File pythonDir) throws YoutubeDLException {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)pythonDir, (String)"pythonDir");
        File pythonLib = new File(binDir, pythonLibName);
        String pythonSize = String.valueOf(pythonLib.length());
        if (!pythonDir.exists() || this.shouldUpdatePython(appContext, pythonSize)) {
            FileUtils.deleteQuietly((File)pythonDir);
            pythonDir.mkdirs();
            try {
                ZipUtils.INSTANCE.unzip(pythonLib, pythonDir);
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)pythonDir);
                throw new YoutubeDLException("failed to initialize", e);
            }
            this.updatePython(appContext, pythonSize);
        }
    }

    private final boolean shouldUpdatePython(Context appContext, String version) {
        return !Intrinsics.areEqual((Object)version, (Object)SharedPrefsHelper.get((Context)appContext, (String)pythonLibVersion));
    }

    private final void updatePython(Context appContext, String version) {
        SharedPrefsHelper.update((Context)appContext, (String)pythonLibVersion, (String)version);
    }

    private final void assertInit() {
        if (!initialized) {
            boolean bl = false;
            String string = "instance not initialized";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final VideoInfo getInfo(@NotNull String url) throws YoutubeDLException, InterruptedException, CanceledException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        YoutubeDLRequest request = new YoutubeDLRequest(url);
        return this.getInfo(request);
    }

    @NotNull
    public final VideoInfo getInfo(@NotNull YoutubeDLRequest request) throws YoutubeDLException, InterruptedException, CanceledException {
        VideoInfo videoInfo;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.addOption("--dump-json");
        YoutubeDLResponse response = this.execute(request, null, null);
        try {
            videoInfo = (VideoInfo)objectMapper.readValue(response.getOut(), VideoInfo.class);
        }
        catch (IOException e) {
            throw new YoutubeDLException("Unable to parse video information", e);
        }
        VideoInfo videoInfo2 = videoInfo;
        if (videoInfo2 == null) {
            throw new YoutubeDLException("Failed to fetch video information");
        }
        VideoInfo videoInfo3 = videoInfo2;
        return videoInfo3;
    }

    private final boolean ignoreErrors(YoutubeDLRequest request, String out) {
        return request.hasOption("--dump-json") && !(((CharSequence)out).length() == 0) && request.hasOption("--ignore-errors");
    }

    public final boolean destroyProcessById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (idProcessMap.containsKey(id)) {
            Process p = idProcessMap.get(id);
            boolean alive = true;
            if (Build.VERSION.SDK_INT >= 26) {
                Process process = p;
                Intrinsics.checkNotNull((Object)process);
                alive = process.isAlive();
            }
            if (alive) {
                Process process = p;
                Intrinsics.checkNotNull((Object)process);
                process.destroy();
                idProcessMap.remove(id);
                return true;
            }
        }
        return false;
    }

    @JvmOverloads
    @NotNull
    public final YoutubeDLResponse execute(@NotNull YoutubeDLRequest request, @Nullable String processId, @Nullable Function3<? super Float, ? super Long, ? super String, Unit> callback) throws YoutubeDLException, InterruptedException, CanceledException {
        int n;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.assertInit();
        if (processId != null && idProcessMap.containsKey(processId)) {
            throw new YoutubeDLException("Process ID already exists");
        }
        if (!request.hasOption("--cache-dir") || request.getOption("--cache-dir") == null) {
            request.addOption("--no-cache-dir");
        }
        File file = ffmpegPath;
        Intrinsics.checkNotNull((Object)file);
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ffmpegPath!!.absolutePath");
        request.addOption("--ffmpeg-location", string);
        YoutubeDLResponse youtubeDLResponse = null;
        Object process = null;
        int exitCode = 0;
        StringBuffer outBuffer = new StringBuffer();
        StringBuffer errBuffer = new StringBuffer();
        long startTime = System.currentTimeMillis();
        List<String> args = request.buildCommand();
        List command = new ArrayList();
        Object[] objectArray = new String[2];
        File file2 = pythonPath;
        Intrinsics.checkNotNull((Object)file2);
        objectArray[0] = file2.getAbsolutePath();
        File file3 = ytdlpPath;
        Intrinsics.checkNotNull((Object)file3);
        objectArray[1] = file3.getAbsolutePath();
        command.addAll(CollectionsKt.listOf((Object[])objectArray));
        command.addAll((Collection)args);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Object object = processBuilder.environment();
        Map<String, String> $this$execute_u24lambda_u241 = object;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$execute_u24lambda_u241, (String)"this");
        $this$execute_u24lambda_u241.put("LD_LIBRARY_PATH", ENV_LD_LIBRARY_PATH);
        $this$execute_u24lambda_u241.put("SSL_CERT_FILE", ENV_SSL_CERT_FILE);
        StringBuilder stringBuilder = new StringBuilder().append(System.getenv("PATH")).append(':');
        File file4 = binDir;
        Intrinsics.checkNotNull((Object)file4);
        $this$execute_u24lambda_u241.put("PATH", stringBuilder.append(file4.getAbsolutePath()).toString());
        $this$execute_u24lambda_u241.put("PYTHONHOME", ENV_PYTHONHOME);
        $this$execute_u24lambda_u241.put("HOME", ENV_PYTHONHOME);
        try {
            Process process2 = processBuilder.start();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"{\n            processBuilder.start()\n        }");
            object = process2;
        }
        catch (IOException e) {
            throw new YoutubeDLException(e);
        }
        process = object;
        if (processId != null) {
            Map<String, Process> map = idProcessMap;
            Intrinsics.checkNotNullExpressionValue(map, (String)"idProcessMap");
            map.put(processId, (Process)process);
        }
        InputStream outStream = ((Process)process).getInputStream();
        InputStream errStream = ((Process)process).getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)outStream, (String)"outStream");
        StreamProcessExtractor stdOutProcessor = new StreamProcessExtractor(outBuffer, outStream, callback);
        Intrinsics.checkNotNullExpressionValue((Object)errStream, (String)"errStream");
        StreamGobbler stdErrProcessor = new StreamGobbler(errBuffer, errStream);
        try {
            stdOutProcessor.join();
            stdErrProcessor.join();
            n = ((Process)process).waitFor();
        }
        catch (InterruptedException e) {
            ((Process)process).destroy();
            if (processId != null) {
                idProcessMap.remove(processId);
            }
            throw e;
        }
        exitCode = n;
        String string2 = outBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outBuffer.toString()");
        String out = string2;
        String string3 = errBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"errBuffer.toString()");
        String err = string3;
        if (exitCode > 0) {
            if (processId != null && !idProcessMap.containsKey(processId)) {
                throw new CanceledException();
            }
            if (!this.ignoreErrors(request, out)) {
                idProcessMap.remove(processId);
                throw new YoutubeDLException(err);
            }
        }
        idProcessMap.remove(processId);
        long elapsedTime = System.currentTimeMillis() - startTime;
        youtubeDLResponse = new YoutubeDLResponse(command, exitCode, elapsedTime, out, err);
        return youtubeDLResponse;
    }

    public static /* synthetic */ YoutubeDLResponse execute$default(YoutubeDL youtubeDL, YoutubeDLRequest youtubeDLRequest, String string, Function3 function3, int n, Object object) throws YoutubeDLException, InterruptedException, CanceledException {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            function3 = null;
        }
        return youtubeDL.execute(youtubeDLRequest, string, (Function3<? super Float, ? super Long, ? super String, Unit>)function3);
    }

    @Nullable
    public final synchronized UpdateStatus updateYoutubeDL(@NotNull Context appContext, @NotNull UpdateChannel updateChannel) throws YoutubeDLException {
        UpdateStatus updateStatus;
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)updateChannel, (String)"updateChannel");
        this.assertInit();
        try {
            updateStatus = YoutubeDLUpdater.INSTANCE.update$library_release(appContext, updateChannel);
        }
        catch (IOException e) {
            throw new YoutubeDLException("failed to update youtube-dl", e);
        }
        return updateStatus;
    }

    public static /* synthetic */ UpdateStatus updateYoutubeDL$default(YoutubeDL youtubeDL, Context context, UpdateChannel updateChannel, int n, Object object) throws YoutubeDLException {
        if ((n & 2) != 0) {
            updateChannel = UpdateChannel.STABLE.INSTANCE;
        }
        return youtubeDL.updateYoutubeDL(context, updateChannel);
    }

    @Nullable
    public final String version(@Nullable Context appContext) {
        return YoutubeDLUpdater.INSTANCE.version(appContext);
    }

    @Nullable
    public final String versionName(@Nullable Context appContext) {
        return YoutubeDLUpdater.INSTANCE.versionName(appContext);
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @JvmStatic
    @NotNull
    public static final YoutubeDL getInstance() {
        return INSTANCE;
    }

    @JvmOverloads
    @NotNull
    public final YoutubeDLResponse execute(@NotNull YoutubeDLRequest request, @Nullable String processId) throws YoutubeDLException, InterruptedException, CanceledException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return YoutubeDL.execute$default(this, request, processId, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final YoutubeDLResponse execute(@NotNull YoutubeDLRequest request) throws YoutubeDLException, InterruptedException, CanceledException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return YoutubeDL.execute$default(this, request, null, null, 6, null);
    }

    static {
        idProcessMap = Collections.synchronizedMap(new HashMap());
        objectMapper = new ObjectMapper();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/yausername/youtubedl_android/YoutubeDL$CanceledException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "library_release"})
    public static final class CanceledException
    extends Exception {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/yausername/youtubedl_android/YoutubeDL$UpdateStatus;", "", "(Ljava/lang/String;I)V", "DONE", "ALREADY_UP_TO_DATE", "library_release"})
    public static final class UpdateStatus
    extends Enum<UpdateStatus> {
        public static final /* enum */ UpdateStatus DONE = new UpdateStatus();
        public static final /* enum */ UpdateStatus ALREADY_UP_TO_DATE = new UpdateStatus();
        private static final /* synthetic */ UpdateStatus[] $VALUES;

        public static UpdateStatus[] values() {
            return (UpdateStatus[])$VALUES.clone();
        }

        public static UpdateStatus valueOf(String value) {
            return Enum.valueOf(UpdateStatus.class, value);
        }

        static {
            $VALUES = updateStatusArray = new UpdateStatus[]{UpdateStatus.DONE, UpdateStatus.ALREADY_UP_TO_DATE};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0003\u0007\b\tB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel;", "", "apiUrl", "", "(Ljava/lang/String;)V", "getApiUrl", "()Ljava/lang/String;", "Companion", "NIGHTLY", "STABLE", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel$NIGHTLY;", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel$STABLE;", "library_release"})
    public static abstract class UpdateChannel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String apiUrl;
        @JvmField
        @NotNull
        public static final STABLE _STABLE = STABLE.INSTANCE;
        @JvmField
        @NotNull
        public static final NIGHTLY _NIGHTLY = NIGHTLY.INSTANCE;

        private UpdateChannel(String apiUrl) {
            this.apiUrl = apiUrl;
        }

        @NotNull
        public final String getApiUrl() {
            return this.apiUrl;
        }

        public /* synthetic */ UpdateChannel(String apiUrl, DefaultConstructorMarker $constructor_marker) {
            this(apiUrl);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel$STABLE;", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel;", "()V", "library_release"})
        public static final class STABLE
        extends UpdateChannel {
            @NotNull
            public static final STABLE INSTANCE = new STABLE();

            private STABLE() {
                super("https://api.github.com/repos/yt-dlp/yt-dlp/releases/latest", null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel$NIGHTLY;", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel;", "()V", "library_release"})
        public static final class NIGHTLY
        extends UpdateChannel {
            @NotNull
            public static final NIGHTLY INSTANCE = new NIGHTLY();

            private NIGHTLY() {
                super("https://api.github.com/repos/yt-dlp/yt-dlp-nightly-builds/releases/latest", null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel$Companion;", "", "()V", "_NIGHTLY", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel$NIGHTLY;", "_STABLE", "Lcom/yausername/youtubedl_android/YoutubeDL$UpdateChannel$STABLE;", "library_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

