/*
 * Decompiled with CFR 0.152.
 */
package com.yausername.youtubedl_android;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012 \u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/yausername/youtubedl_android/StreamProcessExtractor;", "Ljava/lang/Thread;", "buffer", "Ljava/lang/StringBuffer;", "stream", "Ljava/io/InputStream;", "callback", "Lkotlin/Function3;", "", "", "", "", "(Ljava/lang/StringBuffer;Ljava/io/InputStream;Lkotlin/jvm/functions/Function3;)V", "eta", "p", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "pAria2c", "progress", "convertToSeconds", "", "minutes", "seconds", "getEta", "line", "getProgress", "processOutputLine", "run", "Companion", "library_release"})
public final class StreamProcessExtractor
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuffer buffer;
    @NotNull
    private final InputStream stream;
    @Nullable
    private final Function3<Float, Long, String, Unit> callback;
    private final Pattern p;
    private final Pattern pAria2c;
    private float progress;
    private long eta;
    private static final String TAG = StreamProcessExtractor.class.getSimpleName();
    private static final long ETA = -1L;
    private static final float PERCENT = -1.0f;
    private static final int GROUP_PERCENT = 1;
    private static final int GROUP_MINUTES = 2;
    private static final int GROUP_SECONDS = 3;

    public StreamProcessExtractor(@NotNull StringBuffer buffer, @NotNull InputStream stream, @Nullable Function3<? super Float, ? super Long, ? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.buffer = buffer;
        this.stream = stream;
        this.callback = callback;
        this.p = Pattern.compile("\\[download\\]\\s+(\\d+\\.\\d)% .* ETA (\\d+):(\\d+)");
        this.pAria2c = Pattern.compile("\\[#\\w{6}.*\\((\\d*\\.*\\d+)%\\).*?((\\d+)m)*((\\d+)s)*]");
        this.progress = -1.0f;
        this.eta = -1L;
        this.start();
    }

    @Override
    public void run() {
        try {
            Reader input = new InputStreamReader(this.stream, StandardCharsets.UTF_8);
            StringBuilder currentLine = new StringBuilder();
            int nextChar = 0;
            while (true) {
                int n;
                int it = n = input.read();
                boolean bl = false;
                nextChar = it;
                if (n != -1) {
                    this.buffer.append((char)nextChar);
                    if (nextChar == 13 || nextChar == 10 && this.callback != null) {
                        String line;
                        Intrinsics.checkNotNullExpressionValue((Object)currentLine.toString(), (String)"currentLine.toString()");
                        if (StringsKt.startsWith$default((String)line, (String)"[", (boolean)false, (int)2, null)) {
                            this.processOutputLine(line);
                        }
                        currentLine.setLength(0);
                        continue;
                    }
                    currentLine.append((char)nextChar);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
    }

    private final void processOutputLine(String line) {
        block0: {
            Function3<Float, Long, String, Unit> function3 = this.callback;
            if (function3 == null) break block0;
            Function3<Float, Long, String, Unit> it = function3;
            boolean bl = false;
            it.invoke((Object)Float.valueOf(this.getProgress(line)), (Object)this.getEta(line), (Object)line);
        }
    }

    private final float getProgress(String line) {
        Matcher matcher = this.p.matcher(line);
        if (matcher.find()) {
            float f;
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(GROUP_PERCENT)");
            float it = f = Float.parseFloat(string);
            boolean bl = false;
            this.progress = it;
            return f;
        }
        Matcher mAria2c = this.pAria2c.matcher(line);
        if (mAria2c.find()) {
            float f;
            String string = mAria2c.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mAria2c.group(1)");
            float it = f = Float.parseFloat(string);
            boolean bl = false;
            this.progress = it;
            return f;
        }
        return this.progress;
    }

    private final long getEta(String line) {
        Matcher matcher = this.p.matcher(line);
        if (matcher.find()) {
            int n;
            int it = n = this.convertToSeconds(matcher.group(2), matcher.group(3));
            boolean bl = false;
            this.eta = it;
            return n;
        }
        Matcher mAria2c = this.pAria2c.matcher(line);
        if (mAria2c.find()) {
            int n;
            int it = n = this.convertToSeconds(mAria2c.group(3), mAria2c.group(5));
            boolean bl = false;
            this.eta = it;
            return n;
        }
        return this.eta;
    }

    private final int convertToSeconds(String minutes, String seconds) {
        if (seconds == null) {
            return 0;
        }
        if (minutes == null) {
            return Integer.parseInt(seconds);
        }
        return Integer.parseInt(minutes) * 60 + Integer.parseInt(seconds);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/yausername/youtubedl_android/StreamProcessExtractor$Companion;", "", "()V", "ETA", "", "GROUP_MINUTES", "", "GROUP_PERCENT", "GROUP_SECONDS", "PERCENT", "", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

