/*
 * Decompiled with CFR 0.152.
 */
package com.github.yangkangli.logger.utils;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.yangkangli.logger.ALogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Utils {
    @NonNull
    public static <T> T checkNotNull(@Nullable T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String getTopBorder(String subTag, int maxLength, int linkerLength) {
        int tagLength;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u250c");
        int n = tagLength = TextUtils.isEmpty((CharSequence)subTag) ? 0 : subTag.length() + linkerLength;
        while (stringBuilder.length() + tagLength < maxLength) {
            stringBuilder.append("\u2500");
        }
        return stringBuilder.toString();
    }

    public static String getDivider(String subTag, int maxLength, int linkerLength) {
        int tagLength;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("|-");
        int n = tagLength = TextUtils.isEmpty((CharSequence)subTag) ? 0 : subTag.length() + linkerLength;
        while (stringBuilder.length() + tagLength < maxLength) {
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    public static String getBottomBorder(String subTag, int maxLength, int linkerLength) {
        int tagLength;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u2514");
        int n = tagLength = TextUtils.isEmpty((CharSequence)subTag) ? 0 : subTag.length() + linkerLength;
        while (stringBuilder.length() + tagLength < maxLength) {
            stringBuilder.append("\u2500");
        }
        return stringBuilder.toString();
    }

    public static List<StackTraceElement> getTraceList(StackTraceElement[] elements, int methodCount) {
        int count = 0;
        boolean found = false;
        ArrayList<StackTraceElement> retList = new ArrayList<StackTraceElement>();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            String className = element.getClassName();
            if (ALogger.class.getName().equals(className)) {
                found = true;
                continue;
            }
            if (found) {
                retList.add(element);
                ++count;
            }
            if (count >= methodCount) break;
        }
        return retList;
    }

    public static String getSimpleClassName(@NonNull String className) {
        Utils.checkNotNull(className);
        int lastIndex = className.lastIndexOf(".");
        return className.substring(lastIndex + 1);
    }

    public static String[] splitMessage(@NonNull String message) {
        Utils.checkNotNull(message);
        String[] lines = message.split(System.getProperty("line.separator"));
        return lines;
    }

    public static String getLevelName(int priority) {
        switch (priority) {
            case 2: {
                return "V";
            }
            case 3: {
                return "D";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "W";
            }
            case 6: {
                return "E";
            }
            case 7: {
                return "A";
            }
        }
        return "U";
    }

    public static String toString(Object object) {
        if (object != null) {
            if (!object.getClass().isArray()) {
                return object.toString();
            }
            if (object instanceof boolean[]) {
                return Arrays.toString((boolean[])object);
            }
            if (object instanceof byte[]) {
                return Arrays.toString((byte[])object);
            }
            if (object instanceof char[]) {
                return Arrays.toString((char[])object);
            }
            if (object instanceof short[]) {
                return Arrays.toString((short[])object);
            }
            if (object instanceof int[]) {
                return Arrays.toString((int[])object);
            }
            if (object instanceof long[]) {
                return Arrays.toString((long[])object);
            }
            if (object instanceof float[]) {
                return Arrays.toString((float[])object);
            }
            if (object instanceof double[]) {
                return Arrays.toString((double[])object);
            }
            if (object instanceof Object[]) {
                return Arrays.deepToString((Object[])object);
            }
            return "Couldn't find a correct type for the object";
        }
        return null;
    }
}

