/*
 * Decompiled with CFR 0.152.
 */
package com.github.yangkangli.logger.core;

public class BaseLogStrategy {
    private static final String DEFAULT_BASE_TAG = "ALogger";
    private static final String DEFAULT_TAG_LINKER = "->";
    private static final int DEFAULT_BORDER_LENGTH = 120;
    private boolean showThreadName;
    private boolean showStackTrace;
    private int methodCount;
    private String baseTag;
    private String linker;
    private int linkerLength;
    private int borderMaxLength;

    protected BaseLogStrategy(Builder builder) {
        this.showThreadName = builder.showThreadName;
        this.showStackTrace = builder.showStackTrace;
        this.methodCount = builder.methodCount;
        this.baseTag = builder.baseTag;
        this.linker = builder.linker;
        this.linkerLength = builder.linker.length();
        this.borderMaxLength = builder.borderMaxLength;
    }

    public boolean isShowThreadName() {
        return this.showThreadName;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public String getBaseTag() {
        return this.baseTag;
    }

    public String getLinker() {
        return this.linker;
    }

    public int getLinkerLength() {
        return this.linkerLength;
    }

    public int getBorderMaxLength() {
        return this.borderMaxLength;
    }

    public static abstract class Builder<T extends BaseLogStrategy> {
        private boolean showThreadName = true;
        private boolean showStackTrace = false;
        private int methodCount = 5;
        private String baseTag = "ALogger";
        private String linker = "->";
        private int borderMaxLength = 120;

        public Builder setShowThreadName(boolean show) {
            this.showThreadName = show;
            return this;
        }

        public Builder setShowStackTrace(boolean show) {
            this.showStackTrace = show;
            return this;
        }

        public Builder setMethodCount(int count) {
            this.methodCount = count;
            return this;
        }

        public Builder setBaseTag(String baseTag) {
            this.baseTag = baseTag;
            return this;
        }

        public Builder setLinker(String linker) {
            this.linker = linker;
            return this;
        }

        public Builder setBordermaxLength(int length) {
            this.borderMaxLength = length;
            return this;
        }

        public abstract T build();
    }
}

