/*
 * Decompiled with CFR 0.152.
 */
package com.mobile.ffmpeg.util;

import android.os.AsyncTask;
import com.arthenica.mobileffmpeg.Config;
import com.mobile.ffmpeg.FFmpeg;
import com.mobile.ffmpeg.Statistics;
import com.mobile.ffmpeg.StatisticsCallback;
import com.mobile.ffmpeg.util.FFmpegExecuteCallback;

public class FFmpegAsyncUtils
extends AsyncTask<String[], Integer, Integer>
implements StatisticsCallback {
    private FFmpegExecuteCallback mCallback;

    public FFmpegAsyncUtils setCallback(FFmpegExecuteCallback mCallback) {
        this.mCallback = mCallback;
        return this;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (null != this.mCallback) {
            this.mCallback.onFFmpegStart();
        }
        Config.resetStatistics();
        Config.enableStatisticsCallback(this);
    }

    protected Integer doInBackground(String[] ... strings) {
        if (this.isCancelled()) {
            return 255;
        }
        return FFmpeg.execute(strings[0]);
    }

    @Override
    public void apply(Statistics statistics) {
        if (null != statistics) {
            this.publishProgress(new Integer[]{statistics.getTime()});
        }
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.isCancelled() || null == this.mCallback) {
            return;
        }
        this.mCallback.onFFmpegProgress(values[0]);
    }

    protected void onPostExecute(Integer integer) {
        super.onPostExecute((Object)integer);
        if (null == this.mCallback) {
            return;
        }
        if (integer == 0) {
            this.mCallback.onFFmpegSucceed(Config.getLastCommandOutput());
        } else {
            this.mCallback.onFFmpegFailed(Config.getLastCommandOutput());
        }
    }

    @Override
    public void onCancel() {
        this.cancel(true);
        FFmpeg.cancel();
        if (null != this.mCallback) {
            this.mCallback.onFFmpegCancel();
        }
    }
}

