/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.mobileffmpeg;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.arthenica.mobileffmpeg.AbiDetect;
import com.mobile.ffmpeg.Abi;
import com.mobile.ffmpeg.CameraSupport;
import com.mobile.ffmpeg.FFmpeg;
import com.mobile.ffmpeg.Level;
import com.mobile.ffmpeg.LogCallback;
import com.mobile.ffmpeg.LogMessage;
import com.mobile.ffmpeg.Packages;
import com.mobile.ffmpeg.Statistics;
import com.mobile.ffmpeg.StatisticsCallback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Config {
    public static final int RETURN_CODE_SUCCESS = 0;
    public static final int RETURN_CODE_CANCEL = 255;
    private static int lastReturnCode = 0;
    public static final String TAG = "mobile-ffmpeg";
    public static final String MOBILE_FFMPEG_PIPE_PREFIX = "mf_pipe_";
    private static LogCallback logCallbackFunction;
    private static Level activeLogLevel;
    private static StatisticsCallback statisticsCallbackFunction;
    private static Statistics lastReceivedStatistics;
    private static int lastCreatedPipeIndex;

    private Config() {
    }

    public static void enableRedirection() {
        Config.enableNativeRedirection();
    }

    public static void disableRedirection() {
        Config.disableNativeRedirection();
    }

    public static Level getLogLevel() {
        return activeLogLevel;
    }

    public static void setLogLevel(Level level) {
        if (level != null) {
            activeLogLevel = level;
            Config.setNativeLogLevel(level.getValue());
        }
    }

    public static void enableLogCallback(LogCallback newLogCallback) {
        logCallbackFunction = newLogCallback;
    }

    public static void enableStatisticsCallback(StatisticsCallback statisticsCallback) {
        statisticsCallbackFunction = statisticsCallback;
    }

    private static void log(int levelValue, byte[] logMessage) {
        Level level = Level.from(levelValue);
        String text = new String(logMessage);
        if (activeLogLevel == Level.AV_LOG_QUIET && levelValue != Level.AV_LOG_STDERR.getValue() || levelValue > activeLogLevel.getValue()) {
            return;
        }
        if (logCallbackFunction != null) {
            try {
                logCallbackFunction.apply(new LogMessage(level, text));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception thrown inside LogCallback block", (Throwable)e);
            }
        } else {
            switch (level) {
                case AV_LOG_QUIET: {
                    break;
                }
                case AV_LOG_TRACE: 
                case AV_LOG_DEBUG: {
                    Log.d((String)TAG, (String)text);
                    break;
                }
                case AV_LOG_STDERR: 
                case AV_LOG_VERBOSE: {
                    Log.v((String)TAG, (String)text);
                    break;
                }
                case AV_LOG_INFO: {
                    Log.i((String)TAG, (String)text);
                    break;
                }
                case AV_LOG_WARNING: {
                    Log.w((String)TAG, (String)text);
                    break;
                }
                case AV_LOG_ERROR: 
                case AV_LOG_FATAL: 
                case AV_LOG_PANIC: {
                    Log.e((String)TAG, (String)text);
                    break;
                }
                default: {
                    Log.v((String)TAG, (String)text);
                }
            }
        }
    }

    private static void statistics(int videoFrameNumber, float videoFps, float videoQuality, long size, int time, double bitrate, double speed) {
        Statistics newStatistics = new Statistics(videoFrameNumber, videoFps, videoQuality, size, time, bitrate, speed);
        lastReceivedStatistics.update(newStatistics);
        if (statisticsCallbackFunction != null) {
            try {
                statisticsCallbackFunction.apply(lastReceivedStatistics);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception thrown inside StatisticsCallback block", (Throwable)e);
            }
        }
    }

    public static Statistics getLastReceivedStatistics() {
        return lastReceivedStatistics;
    }

    public static void resetStatistics() {
        lastReceivedStatistics = new Statistics();
    }

    public static int setFontconfigConfigurationPath(String path) {
        return Config.setNativeEnvironmentVariable("FONTCONFIG_PATH", path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFontDirectory(Context context, String fontDirectoryPath, Map<String, String> fontNameMapping) {
        File fontConfiguration;
        File cacheDir = context.getCacheDir();
        int validFontNameMappingCount = 0;
        File tempConfigurationDirectory = new File(cacheDir, ".mobileffmpeg");
        if (!tempConfigurationDirectory.exists()) {
            boolean tempFontConfDirectoryCreated = tempConfigurationDirectory.mkdirs();
            Log.d((String)TAG, (String)String.format("Created temporary font conf directory: %s.", tempFontConfDirectoryCreated));
        }
        if ((fontConfiguration = new File(tempConfigurationDirectory, "fonts.conf")).exists()) {
            boolean fontConfigurationDeleted = fontConfiguration.delete();
            Log.d((String)TAG, (String)String.format("Deleted old temporary font configuration: %s.", fontConfigurationDeleted));
        }
        StringBuilder fontNameMappingBlock = new StringBuilder("");
        if (fontNameMapping != null && fontNameMapping.size() > 0) {
            fontNameMapping.entrySet();
            for (Map.Entry<String, String> mapping : fontNameMapping.entrySet()) {
                String fontName = mapping.getKey();
                String mappedFontName = mapping.getValue();
                if (fontName == null || mappedFontName == null || fontName.trim().length() <= 0 || mappedFontName.trim().length() <= 0) continue;
                fontNameMappingBlock.append("        <match target=\"pattern\">\n");
                fontNameMappingBlock.append("                <test qual=\"any\" name=\"family\">\n");
                fontNameMappingBlock.append(String.format("                        <string>%s</string>\n", fontName));
                fontNameMappingBlock.append("                </test>\n");
                fontNameMappingBlock.append("                <edit name=\"family\" mode=\"assign\" binding=\"same\">\n");
                fontNameMappingBlock.append(String.format("                        <string>%s</string>\n", mappedFontName));
                fontNameMappingBlock.append("                </edit>\n");
                fontNameMappingBlock.append("        </match>\n");
                ++validFontNameMappingCount;
            }
        }
        String fontConfig = "<?xml version=\"1.0\"?>\n<!DOCTYPE fontconfig SYSTEM \"fonts.dtd\">\n<fontconfig>\n    <dir>.</dir>\n    <dir>" + fontDirectoryPath + "</dir>\n" + fontNameMappingBlock + "</fontconfig>";
        AtomicReference<FileOutputStream> reference = new AtomicReference<FileOutputStream>();
        try {
            FileOutputStream outputStream = new FileOutputStream(fontConfiguration);
            reference.set(outputStream);
            outputStream.write(fontConfig.getBytes());
            outputStream.flush();
            Log.d((String)TAG, (String)String.format("Saved new temporary font configuration with %d font name mappings.", validFontNameMappingCount));
            Config.setFontconfigConfigurationPath(tempConfigurationDirectory.getAbsolutePath());
            Log.d((String)TAG, (String)String.format("Font directory %s registered successfully.", fontDirectoryPath));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)String.format("Failed to set font directory: %s.", fontDirectoryPath), (Throwable)e);
        }
        finally {
            if (reference.get() != null) {
                try {
                    ((FileOutputStream)reference.get()).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getPackageName() {
        return Packages.getPackageName();
    }

    public static List<String> getExternalLibraries() {
        return Packages.getExternalLibraries();
    }

    public static String registerNewFFmpegPipe(Context context) {
        File cacheDir = context.getCacheDir();
        String newFFmpegPipePath = cacheDir + File.separator + MOBILE_FFMPEG_PIPE_PREFIX + ++lastCreatedPipeIndex;
        Config.closeFFmpegPipe(newFFmpegPipePath);
        int rc = Config.registerNewNativeFFmpegPipe(newFFmpegPipePath);
        if (rc == 0) {
            return newFFmpegPipePath;
        }
        Log.e((String)TAG, (String)String.format("Failed to register new FFmpeg pipe %s. Operation failed with rc=%d.", newFFmpegPipePath, rc));
        return null;
    }

    public static void closeFFmpegPipe(String ffmpegPipePath) {
        File file = new File(ffmpegPipePath);
        if (file.exists()) {
            file.delete();
        }
    }

    public static List<String> getSupportedCameraIds(Context context) {
        ArrayList<String> detectedCameraIdList = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 24) {
            detectedCameraIdList.addAll(CameraSupport.extractSupportedCameraIds(context));
        }
        return detectedCameraIdList;
    }

    public static String getFFmpegVersion() {
        return Config.getNativeFFmpegVersion();
    }

    public static String getVersion() {
        if (AbiDetect.isNativeLTSBuild()) {
            return String.format("%s-lts", Config.getNativeVersion());
        }
        return Config.getNativeVersion();
    }

    public static boolean isLTSBuild() {
        return AbiDetect.isNativeLTSBuild();
    }

    public static String getBuildDate() {
        return Config.getNativeBuildDate();
    }

    public static int getLastReturnCode() {
        return lastReturnCode;
    }

    public static String getLastCommandOutput() {
        String nativeLastCommandOutput = Config.getNativeLastCommandOutput();
        if (nativeLastCommandOutput != null) {
            nativeLastCommandOutput = nativeLastCommandOutput.replace('\r', '\n');
        }
        return nativeLastCommandOutput;
    }

    public static void printLastCommandOutput(int logPriority) {
        int LOGGER_ENTRY_MAX_LEN = 4000;
        String buffer = Config.getLastCommandOutput();
        do {
            if (buffer.length() <= 4000) {
                Log.println((int)logPriority, (String)TAG, (String)buffer);
                buffer = "";
                continue;
            }
            int index = buffer.substring(0, 4000).lastIndexOf(10);
            if (index < 0) {
                Log.println((int)logPriority, (String)TAG, (String)buffer.substring(0, 4000));
                buffer = buffer.substring(4000);
                continue;
            }
            Log.println((int)logPriority, (String)TAG, (String)buffer.substring(0, index));
            buffer = buffer.substring(index);
        } while (buffer.length() > 0);
    }

    public static void setLastReturnCode(int newLastReturnCode) {
        lastReturnCode = newLastReturnCode;
    }

    private static native void enableNativeRedirection();

    private static native void disableNativeRedirection();

    private static native void setNativeLogLevel(int var0);

    private static native int getNativeLogLevel();

    static native String getNativeFFmpegVersion();

    static native String getNativeVersion();

    public static native int nativeFFmpegExecute(String[] var0);

    public static native void nativeFFmpegCancel();

    public static native int nativeFFprobeExecute(String[] var0);

    public static native int registerNewNativeFFmpegPipe(String var0);

    public static native String getNativeBuildDate();

    public static native int setNativeEnvironmentVariable(String var0, String var1);

    static native String getNativeLastCommandOutput();

    static {
        Log.i((String)TAG, (String)"Loading mobile-ffmpeg.");
        if (Build.VERSION.SDK_INT < 21) {
            List<String> externalLibrariesEnabled = Config.getExternalLibraries();
            if (externalLibrariesEnabled.contains("tesseract") || externalLibrariesEnabled.contains("x265") || externalLibrariesEnabled.contains("snappy") || externalLibrariesEnabled.contains("openh264")) {
                System.loadLibrary("c++_shared");
            }
            System.loadLibrary("cpufeatures");
            System.loadLibrary("avutil");
            System.loadLibrary("swscale");
            System.loadLibrary("swresample");
            System.loadLibrary("avcodec");
            System.loadLibrary("avformat");
            System.loadLibrary("avfilter");
            System.loadLibrary("avdevice");
        }
        Abi.class.getName();
        FFmpeg.class.getName();
        boolean nativeLibraryLoaded = false;
        if ("arm-v7a".equals(AbiDetect.getNativeAbi())) {
            if (AbiDetect.isNativeLTSBuild()) {
                try {
                    System.loadLibrary("mobileffmpeg_armv7a_neon");
                    nativeLibraryLoaded = true;
                    AbiDetect.setArmV7aNeonLoaded(true);
                }
                catch (UnsatisfiedLinkError e) {
                    Log.i((String)TAG, (String)"NEON supported armeabi-v7a library not found. Loading default armeabi-v7a library.", (Throwable)e);
                }
            } else {
                AbiDetect.setArmV7aNeonLoaded(true);
            }
        }
        if (!nativeLibraryLoaded) {
            System.loadLibrary("mobileffmpeg");
        }
        Log.i((String)TAG, (String)String.format("Loaded mobile-ffmpeg-%s-%s-%s-%s.", Config.getPackageName(), AbiDetect.getAbi(), Config.getVersion(), Config.getBuildDate()));
        activeLogLevel = Level.from(Config.getNativeLogLevel());
        lastReceivedStatistics = new Statistics();
        Config.enableRedirection();
        lastCreatedPipeIndex = 0;
    }
}

