/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.encryption;

import java.nio.charset.Charset;

public class SafeEncoder {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final byte[] ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 106, 107, 109, 110, 112, 113, 114, 115, 116, 118, 119, 120, 121, 122};
    private static final int MASK_8_BITS = 255;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MASK_5BITS = 31;
    private static final int BITS_PER_ENCODED_BYTE = 5;
    private static final int BYTES_PER_ENCODED_BLOCK = 8;
    private static final int BYTES_PER_UN_ENCODED_BLOCK = 5;
    private byte[] buffer;
    private int position;
    private boolean eof;
    private int modulus;
    private long bitWorkArea;

    private byte decode(byte octet) {
        switch (octet) {
            case 48: 
            case 79: 
            case 111: {
                return 0;
            }
            case 49: 
            case 73: 
            case 76: 
            case 105: 
            case 108: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
            case 71: 
            case 103: {
                return 16;
            }
            case 72: 
            case 104: {
                return 17;
            }
            case 74: 
            case 106: {
                return 18;
            }
            case 75: 
            case 107: {
                return 19;
            }
            case 77: 
            case 109: {
                return 20;
            }
            case 78: 
            case 110: {
                return 21;
            }
            case 80: 
            case 112: {
                return 22;
            }
            case 81: 
            case 113: {
                return 23;
            }
            case 82: 
            case 114: {
                return 24;
            }
            case 83: 
            case 115: {
                return 25;
            }
            case 84: 
            case 116: {
                return 26;
            }
            case 85: 
            case 86: 
            case 117: 
            case 118: {
                return 27;
            }
            case 87: 
            case 119: {
                return 28;
            }
            case 88: 
            case 120: {
                return 29;
            }
            case 89: 
            case 121: {
                return 30;
            }
            case 90: 
            case 122: {
                return 31;
            }
        }
        return -1;
    }

    private boolean isInAlphabet(byte octet) {
        return this.decode(octet) != -1;
    }

    private int available() {
        return this.buffer != null ? this.position : 0;
    }

    private void resizeBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[8192];
            this.position = 0;
        } else {
            byte[] bytes = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, bytes, 0, this.buffer.length);
            this.buffer = bytes;
        }
    }

    private void ensureBufferSize(int size) {
        if (this.buffer == null || this.buffer.length < this.position + size) {
            this.resizeBuffer();
        }
    }

    private void readResults(byte[] bytes) {
        if (this.buffer != null) {
            int len = this.available();
            System.arraycopy(this.buffer, 0, bytes, 0, len);
            this.buffer = null;
        }
    }

    private void reset() {
        this.buffer = null;
        this.position = 0;
        this.modulus = 0;
        this.eof = false;
    }

    public String encodeToString(byte[] bytes) {
        return new String(this.encode(bytes), CHARSET);
    }

    public byte[] decode(String s) {
        return this.decode(s.getBytes(CHARSET));
    }

    private byte[] encode(byte[] bytes) {
        this.reset();
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        this.encode(bytes, bytes.length);
        this.encode(bytes, -1);
        byte[] result = new byte[this.position];
        this.readResults(result);
        return result;
    }

    private byte[] decode(byte[] bytes) {
        this.reset();
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        this.decode(bytes, bytes.length);
        this.decode(bytes, -1);
        byte[] result = new byte[this.position];
        this.readResults(result);
        return result;
    }

    private void encode(byte[] in, int available) {
        int localPosition = 0;
        if (this.eof) {
            return;
        }
        int encodeSize = 8;
        if (available < 0) {
            this.eof = true;
            if (0 == this.modulus) {
                return;
            }
            this.ensureBufferSize(encodeSize);
            switch (this.modulus) {
                case 1: {
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 3) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea << 2) & 0x1F];
                    break;
                }
                case 2: {
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 11) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 6) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 1) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea << 4) & 0x1F];
                    break;
                }
                case 3: {
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 19) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 14) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 9) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 4) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea << 1) & 0x1F];
                    break;
                }
                case 4: {
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 27) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 22) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 17) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 12) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 7) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 2) & 0x1F];
                    this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea << 3) & 0x1F];
                }
            }
        } else {
            for (int i = 0; i < available; ++i) {
                this.ensureBufferSize(encodeSize);
                this.modulus = (this.modulus + 1) % 5;
                int b = in[localPosition++];
                if (b < 0) {
                    b += 256;
                }
                this.bitWorkArea = (this.bitWorkArea << 8) + (long)b;
                if (0 != this.modulus) continue;
                this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 35) & 0x1F];
                this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 30) & 0x1F];
                this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 25) & 0x1F];
                this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 20) & 0x1F];
                this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 15) & 0x1F];
                this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 10) & 0x1F];
                this.buffer[this.position++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 5) & 0x1F];
                this.buffer[this.position++] = ENCODE_TABLE[(int)this.bitWorkArea & 0x1F];
            }
        }
    }

    private void decode(byte[] in, int available) {
        int localPosition = 0;
        if (this.eof) {
            return;
        }
        if (available < 0) {
            this.eof = true;
        }
        int decodeSize = 7;
        for (int i = 0; i < available; ++i) {
            byte b = in[localPosition++];
            this.ensureBufferSize(decodeSize);
            if (!this.isInAlphabet(b)) continue;
            byte result = this.decode(b);
            this.modulus = (this.modulus + 1) % 8;
            this.bitWorkArea = (this.bitWorkArea << 5) + (long)result;
            if (this.modulus != 0) continue;
            this.buffer[this.position++] = (byte)(this.bitWorkArea >> 32 & 0xFFL);
            this.buffer[this.position++] = (byte)(this.bitWorkArea >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(this.bitWorkArea & 0xFFL);
        }
        if (this.eof && this.modulus >= 2) {
            this.ensureBufferSize(decodeSize);
            switch (this.modulus) {
                case 2: {
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 2 & 0xFFL);
                    break;
                }
                case 3: {
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 7 & 0xFFL);
                    break;
                }
                case 4: {
                    this.bitWorkArea >>= 4;
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.position++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 5: {
                    this.bitWorkArea >>= 1;
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.position++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 6: {
                    this.bitWorkArea >>= 6;
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.position++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 7: {
                    this.bitWorkArea >>= 3;
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 24 & 0xFFL);
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.position++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.position++] = (byte)(this.bitWorkArea & 0xFFL);
                }
            }
        }
    }
}

