/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.SharedPreferences;
import com.ironz.binaryprefs.PreferencesEditor;
import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.file.FileAdapter;
import com.ironz.binaryprefs.util.Bits;
import com.ironz.binaryprefs.util.Pair;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class BinaryPreferencesEditor
implements PreferencesEditor {
    private final List<Pair<String, byte[]>> commitList = new ArrayList<Pair<String, byte[]>>(0);
    private final List<String> removeSet = new ArrayList<String>(0);
    private final Class lock;
    private final FileAdapter fileAdapter;
    private final ExceptionHandler exceptionHandler;
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
    private final SharedPreferences preferences;
    private boolean clear;

    BinaryPreferencesEditor(Class lock, FileAdapter fileAdapter, ExceptionHandler exceptionHandler, List<SharedPreferences.OnSharedPreferenceChangeListener> listeners, SharedPreferences preferences) {
        this.lock = lock;
        this.fileAdapter = fileAdapter;
        this.exceptionHandler = exceptionHandler;
        this.listeners = listeners;
        this.preferences = preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putString(String key, String value) {
        Class clazz = this.lock;
        synchronized (clazz) {
            if (value == null) {
                return this.remove(key);
            }
            byte[] bytes = Bits.stringToBytes(value);
            this.commitList.add(new Pair<String, byte[]>(key, bytes));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putStringSet(String key, Set<String> values) {
        Class clazz = this.lock;
        synchronized (clazz) {
            if (values == null) {
                return this.remove(key);
            }
            byte[] bytes = Bits.stringSetToBytes(values);
            this.commitList.add(new Pair<String, byte[]>(key, bytes));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putInt(String key, int value) {
        Class clazz = this.lock;
        synchronized (clazz) {
            byte[] bytes = Bits.intToBytes(value);
            this.commitList.add(new Pair<String, byte[]>(key, bytes));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putLong(String key, long value) {
        Class clazz = this.lock;
        synchronized (clazz) {
            byte[] bytes = Bits.longToBytes(value);
            this.commitList.add(new Pair<String, byte[]>(key, bytes));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putFloat(String key, float value) {
        Class clazz = this.lock;
        synchronized (clazz) {
            byte[] bytes = Bits.floatToBytes(value);
            this.commitList.add(new Pair<String, byte[]>(key, bytes));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putBoolean(String key, boolean value) {
        Class clazz = this.lock;
        synchronized (clazz) {
            byte[] bytes = Bits.booleanToBytes(value);
            this.commitList.add(new Pair<String, byte[]>(key, bytes));
            return this;
        }
    }

    @Override
    public <T extends Externalizable> PreferencesEditor putObject(String key, T value) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor remove(String key) {
        Class clazz = this.lock;
        synchronized (clazz) {
            this.removeSet.add(key);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor clear() {
        Class clazz = this.lock;
        synchronized (clazz) {
            this.clear = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() {
        Class clazz = this.lock;
        synchronized (clazz) {
            this.performWithResult();
        }
    }

    public boolean commit() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    private boolean performWithResult() {
        try {
            this.tryClearAll();
            this.tryRemoveByKeys();
            this.tryStoreByKeys();
            return true;
        }
        catch (Exception e) {
            this.exceptionHandler.handle(e, "apply method");
            return false;
        }
    }

    private void tryClearAll() {
        if (this.clear) {
            this.fileAdapter.clear();
        }
    }

    private void tryRemoveByKeys() {
        for (String name : this.removeSet) {
            this.fileAdapter.remove(name);
            this.notifyListeners(name);
        }
    }

    private void tryStoreByKeys() {
        for (Pair<String, byte[]> pair : this.commitList) {
            String name = pair.getFirst();
            byte[] value = pair.getSecond();
            this.fileAdapter.save(name, value);
            this.notifyListeners(name);
        }
    }

    private void notifyListeners(String key) {
        for (SharedPreferences.OnSharedPreferenceChangeListener listener : this.listeners) {
            listener.onSharedPreferenceChanged(this.preferences, key);
        }
    }
}

