/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext.style;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import com.xycoding.richtext.ImageSpanGetter;
import com.xycoding.richtext.TagBlock;
import com.xycoding.richtext.style.BlockTagStyle;

public class ImageTagStyle
extends BlockTagStyle {
    private static final String UNICODE_REPLACE = "\ufffc";
    private static final String ATTRIBUTE_SRC = "src";
    private static final String TAG_IMAGE = "img";
    private ImageSpanGetter mImageSpanGetter;

    public ImageTagStyle(ImageSpanGetter getter) {
        super(null, TAG_IMAGE);
        this.mImageSpanGetter = getter;
    }

    @Override
    public void start(TagBlock block, SpannableStringBuilder builder) {
        String src;
        if (block.getAttributes() != null && !TextUtils.isEmpty((CharSequence)(src = block.getAttributes().get(ATTRIBUTE_SRC)))) {
            ImageSpan span = this.mImageSpanGetter.getImageSpan(src);
            if (span == null) {
                return;
            }
            int len = builder.length();
            builder.append((CharSequence)UNICODE_REPLACE);
            builder.setSpan((Object)span, len, builder.length(), 33);
        }
    }

    @Override
    public void end(String tagName, SpannableStringBuilder builder) {
    }
}

