/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext.style;

import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import com.xycoding.richtext.TagBlock;
import com.xycoding.richtext.style.BaseTagStyle;
import com.xycoding.richtext.typeface.ClickSpan;
import com.xycoding.richtext.typeface.IStyleSpan;
import java.util.ArrayList;

public class BlockTagStyle
extends BaseTagStyle {
    public BlockTagStyle(IStyleSpan span, String ... tags) {
        super(span, tags);
    }

    @Override
    public void start(TagBlock block, SpannableStringBuilder builder) {
        int len = builder.length();
        builder.setSpan((Object)this, len, len, 17);
    }

    @Override
    public void end(String tagName, SpannableStringBuilder builder) {
        block11: {
            int len = builder.length();
            BlockTagStyle[] styles = (BlockTagStyle[])builder.getSpans(0, builder.length(), BlockTagStyle.class);
            if (styles.length == 0) break block11;
            BlockTagStyle obj = styles[styles.length - 1];
            int start = builder.getSpanStart((Object)obj);
            builder.removeSpan((Object)obj);
            if (start != len) {
                CharacterStyle[] characterStyles;
                builder.setSpan(this.mStyleSpan.getStyleSpan(), start, len, 33);
                if (Build.VERSION.SDK_INT == 23 && styles.length > 1) {
                    BlockTagStyle style;
                    int styleStart;
                    BlockTagStyle[] blockTagStyleArray = styles;
                    int n = blockTagStyleArray.length;
                    for (int i = 0; i < n && start != (styleStart = builder.getSpanStart((Object)(style = blockTagStyleArray[i]))); ++i) {
                        Object span = style.mStyleSpan.getStyleSpan();
                        if (!(span instanceof ForegroundColorSpan)) continue;
                        builder.setSpan(span, start, len, 33);
                        break;
                    }
                } else if (Build.VERSION.SDK_INT >= 24 && (characterStyles = (CharacterStyle[])builder.getSpans(start, len, CharacterStyle.class)) != null && characterStyles.length > 1) {
                    int stylesLength = characterStyles.length;
                    ArrayList<CharacterStyle> removeStyles = new ArrayList<CharacterStyle>();
                    int color = -1;
                    for (int i = stylesLength - 1; i >= 0; --i) {
                        if (color != -1) {
                            for (int j = 0; j <= i; ++j) {
                                CharacterStyle characterStyle = characterStyles[j];
                                if (characterStyle instanceof ClickSpan) {
                                    ((ClickSpan)characterStyle).setNormalTextColor(color);
                                    continue;
                                }
                                if (!(characterStyle instanceof ForegroundColorSpan)) continue;
                                removeStyles.add(characterStyle);
                            }
                            break;
                        }
                        CharacterStyle characterStyle = characterStyles[i];
                        if (characterStyle instanceof ForegroundColorSpan) {
                            color = ((ForegroundColorSpan)characterStyle).getForegroundColor();
                            continue;
                        }
                        if (!(characterStyle instanceof ClickSpan)) continue;
                        color = ((ClickSpan)characterStyle).getNormalTextColor();
                    }
                    for (CharacterStyle style : removeStyles) {
                        builder.removeSpan((Object)style);
                    }
                }
            }
        }
    }

    @Override
    public boolean match(String tagName) {
        return this.mTags.contains(tagName);
    }
}

