/*
 * Decompiled with CFR 0.152.
 */
package gui.ava.html.link;

import gui.ava.html.link.LinkInfo;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

public class LinkHarvester {
    private final JTextComponent textComponent;
    private final List<LinkInfo> links = new ArrayList<LinkInfo>();

    public LinkHarvester(JEditorPane jEditorPane) {
        this.textComponent = jEditorPane;
        this.harvestElement(jEditorPane.getDocument().getDefaultRootElement());
    }

    public List<LinkInfo> getLinks() {
        return this.links;
    }

    private void harvestElement(Element element) {
        Object object;
        if (element == null) {
            return;
        }
        AttributeSet attributeSet = element.getAttributes();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!HTML.Tag.A.equals(obj)) continue;
            object = this.harvestAttributes(element);
            List<Rectangle> list = this.harvestBounds(element);
            if (object.isEmpty() || list.isEmpty()) continue;
            this.links.add(new LinkInfo((Map<String, String>)object, list));
        }
        for (int i = 0; i < element.getElementCount(); ++i) {
            object = element.getElement(i);
            this.harvestElement((Element)object);
        }
    }

    private Map<String, String> harvestAttributes(Element element) {
        Object object = element.getAttributes().getAttribute(HTML.Tag.A);
        if (object instanceof SimpleAttributeSet) {
            SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)object;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.addAttribute(simpleAttributeSet, hashMap, HTML.Attribute.HREF);
            this.addAttribute(simpleAttributeSet, hashMap, HTML.Attribute.TARGET);
            this.addAttribute(simpleAttributeSet, hashMap, HTML.Attribute.TITLE);
            this.addAttribute(simpleAttributeSet, hashMap, HTML.Attribute.CLASS);
            this.addAttribute(simpleAttributeSet, hashMap, "tabindex");
            this.addAttribute(simpleAttributeSet, hashMap, "dir");
            this.addAttribute(simpleAttributeSet, hashMap, "lang");
            this.addAttribute(simpleAttributeSet, hashMap, "accesskey");
            this.addAttribute(simpleAttributeSet, hashMap, "onblur");
            this.addAttribute(simpleAttributeSet, hashMap, "onclick");
            this.addAttribute(simpleAttributeSet, hashMap, "ondblclick");
            this.addAttribute(simpleAttributeSet, hashMap, "onfocus");
            this.addAttribute(simpleAttributeSet, hashMap, "onmousedown");
            this.addAttribute(simpleAttributeSet, hashMap, "onmousemove");
            this.addAttribute(simpleAttributeSet, hashMap, "onmouseout");
            this.addAttribute(simpleAttributeSet, hashMap, "onmouseover");
            this.addAttribute(simpleAttributeSet, hashMap, "onmouseup");
            this.addAttribute(simpleAttributeSet, hashMap, "onkeydown");
            this.addAttribute(simpleAttributeSet, hashMap, "onkeypress");
            this.addAttribute(simpleAttributeSet, hashMap, "onkeyup");
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private void addAttribute(SimpleAttributeSet simpleAttributeSet, Map<String, String> map, Object object) {
        String string = object.toString();
        String string2 = (String)simpleAttributeSet.getAttribute(object);
        if (string2 != null && !string2.equals("")) {
            map.put(string, string2);
        }
    }

    private List<Rectangle> harvestBounds(Element element) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        try {
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            Rectangle rectangle = null;
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle2 = this.textComponent.modelToView(i);
                if (rectangle2 == null) continue;
                if (rectangle == null) {
                    rectangle = rectangle2;
                    continue;
                }
                if (rectangle2.getY() == rectangle.getY()) {
                    rectangle = rectangle.union(rectangle2);
                    continue;
                }
                if (rectangle.getWidth() > 1.0 && rectangle.getHeight() > 1.0) {
                    arrayList.add(rectangle);
                }
                rectangle = null;
            }
            if (rectangle != null && rectangle.getWidth() > 1.0 && rectangle.getHeight() > 1.0) {
                arrayList.add(rectangle);
            }
            return arrayList;
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Got BadLocationException", badLocationException);
        }
    }
}

