/*
 * Decompiled with CFR 0.152.
 */
package com.android.tony.defenselib.hook;

import android.os.Handler;
import android.os.Looper;
import com.android.tony.defenselib.handler.ExceptionDispatcher;
import com.android.tony.defenselib.hook.IHook;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class HookHandler
implements IHook {
    private volatile boolean isHooked;
    private ExceptionDispatcher mExceptionDispatcher;
    private Handler.Callback mOriginCallback;

    public HookHandler(ExceptionDispatcher exceptionDispatcher) {
        this.mExceptionDispatcher = exceptionDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hook() {
        if (this.isHooked()) {
            return;
        }
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method currentActivityThreadMethod = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]);
            currentActivityThreadMethod.setAccessible(true);
            Object currentActivityThread = currentActivityThreadMethod.invoke(null, new Object[0]);
            Field mHField = activityThreadClass.getDeclaredField("mH");
            mHField.setAccessible(true);
            Handler handler = (Handler)mHField.get(currentActivityThread);
            Field callbackField = Handler.class.getDeclaredField("mCallback");
            callbackField.setAccessible(true);
            this.mOriginCallback = (Handler.Callback)callbackField.get(handler);
            Handler.Callback fakeCallback = msg -> {
                try {
                    if (this.mOriginCallback != null) {
                        if (!this.mOriginCallback.handleMessage(msg)) {
                            handler.handleMessage(msg);
                        }
                    } else {
                        handler.handleMessage(msg);
                    }
                }
                catch (Throwable e) {
                    this.mExceptionDispatcher.uncaughtExceptionHappened(Looper.getMainLooper().getThread(), e);
                }
                return true;
            };
            callbackField.set(handler, fakeCallback);
            HookHandler hookHandler = this;
            synchronized (hookHandler) {
                this.isHooked = true;
            }
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
            HookHandler hookHandler = this;
            synchronized (hookHandler) {
                this.isHooked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unHook() {
        if (!this.isHooked()) {
            return;
        }
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method currentActivityThreadMethod = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]);
            currentActivityThreadMethod.setAccessible(true);
            Object currentActivityThread = currentActivityThreadMethod.invoke(null, new Object[0]);
            Field mHandlerField = activityThreadClass.getDeclaredField("mH");
            mHandlerField.setAccessible(true);
            Handler handler = (Handler)mHandlerField.get(currentActivityThread);
            Field callbackField = Handler.class.getDeclaredField("mCallback");
            callbackField.setAccessible(true);
            callbackField.set(handler, this.mOriginCallback);
            HookHandler hookHandler = this;
            synchronized (hookHandler) {
                this.isHooked = false;
            }
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
            HookHandler hookHandler = this;
            synchronized (hookHandler) {
                this.isHooked = true;
            }
        }
    }

    @Override
    public boolean isHooked() {
        return this.isHooked;
    }
}

