/*
 * Decompiled with CFR 0.152.
 */
package com.android.cglib.proxy;

import com.android.cglib.proxy.EnhancerInterface;
import com.android.cglib.proxy.ProxyException;
import java.lang.reflect.Method;

public class MethodProxy {
    private Class subClass;
    private String methodName;
    private Class[] argsType;

    public MethodProxy(Class subClass, String methodName, Class[] argsType) {
        this.subClass = subClass;
        this.methodName = methodName;
        this.argsType = argsType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Method getOriginalMethod() {
        try {
            return this.subClass.getDeclaredMethod(this.methodName, this.argsType);
        }
        catch (NoSuchMethodException e) {
            throw new ProxyException(e);
        }
    }

    public Method getProxyMethod() {
        try {
            return this.subClass.getDeclaredMethod(this.methodName + "$Super$", this.argsType);
        }
        catch (NoSuchMethodException e) {
            throw new ProxyException(e);
        }
    }

    public Object invokeSuper(Object object, Object[] argsValue) throws Exception {
        if (object instanceof EnhancerInterface) {
            return ((EnhancerInterface)object).executeSuperMethod$Enhancer$(this.methodName, this.argsType, argsValue);
        }
        Method method = object.getClass().getDeclaredMethod(this.methodName, this.argsType);
        return method.invoke(object, argsValue);
    }
}

