/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.mvvmquick.util;

import android.util.Log;
import java.util.Locale;

public class LogUtil {
    public static boolean LOGV = false;
    public static boolean LOGD = false;
    public static boolean LOGI = false;
    public static boolean LOGW = false;
    public static boolean LOGE = false;

    public static void v(String tag, String mess) {
        if (LOGV) {
            Log.v((String)tag, (String)mess);
        }
    }

    public static void d(String tag, String mess) {
        if (LOGD) {
            Log.d((String)tag, (String)mess);
        }
    }

    public static void i(String tag, String mess) {
        if (LOGI) {
            Log.i((String)tag, (String)mess);
        }
    }

    public static void w(String tag, String mess) {
        if (LOGW) {
            Log.w((String)tag, (String)mess);
        }
    }

    public static void e(String tag, String mess) {
        if (LOGE) {
            Log.e((String)tag, (String)mess);
        }
    }

    private static String getTag() {
        StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
        String callingClass = "";
        for (int i = 2; i < trace.length; ++i) {
            Class<?> clazz = trace[i].getClass();
            if (clazz.equals(LogUtil.class)) continue;
            callingClass = trace[i].getClassName();
            callingClass = callingClass.substring(callingClass.lastIndexOf(46) + 1);
            break;
        }
        return callingClass;
    }

    public static void v1(String mess) {
        if (LOGV) {
            Log.v((String)LogUtil.getTag(), (String)mess);
        }
    }

    public static void d1(String mess) {
        if (LOGD) {
            Log.d((String)LogUtil.getTag(), (String)mess);
        }
    }

    public static void i1(String mess) {
        if (LOGI) {
            Log.i((String)LogUtil.getTag(), (String)mess);
        }
    }

    public static void w1(String mess) {
        if (LOGW) {
            Log.w((String)LogUtil.getTag(), (String)mess);
        }
    }

    public static void e1(String mess) {
        if (LOGE) {
            Log.e((String)LogUtil.getTag(), (String)mess);
        }
    }

    private static String buildMessage(String msg) {
        StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
        String caller = "";
        for (int i = 2; i < trace.length; ++i) {
            Class<?> clazz = trace[i].getClass();
            if (clazz.equals(LogUtil.class)) continue;
            caller = trace[i].getMethodName();
            break;
        }
        return String.format(Locale.US, "[%d] %s: %s", Thread.currentThread().getId(), caller, msg);
    }

    public static void v2(String mess) {
        if (LOGV) {
            Log.v((String)LogUtil.getTag(), (String)LogUtil.buildMessage(mess));
        }
    }

    public static void d2(String mess) {
        if (LOGD) {
            Log.d((String)LogUtil.getTag(), (String)LogUtil.buildMessage(mess));
        }
    }

    public static void i2(String mess) {
        if (LOGI) {
            Log.i((String)LogUtil.getTag(), (String)LogUtil.buildMessage(mess));
        }
    }

    public static void w2(String mess) {
        if (LOGW) {
            Log.w((String)LogUtil.getTag(), (String)LogUtil.buildMessage(mess));
        }
    }

    public static void e2(String mess) {
        if (LOGE) {
            Log.e((String)LogUtil.getTag(), (String)LogUtil.buildMessage(mess));
        }
    }

    public static void v3(String mess) {
        if (LOGV) {
            Log.v((String)LogUtil.getTag(), (String)LogUtil.getMsgFormat(mess));
        }
    }

    public static void d3(String mess) {
        if (LOGD) {
            Log.d((String)LogUtil.getTag(), (String)LogUtil.getMsgFormat(mess));
        }
    }

    public static void i3(String mess) {
        if (LOGI) {
            Log.i((String)LogUtil.getTag(), (String)LogUtil.getMsgFormat(mess));
        }
    }

    public static void w3(String mess) {
        if (LOGW) {
            Log.w((String)LogUtil.getTag(), (String)LogUtil.getMsgFormat(mess));
        }
    }

    public static void e3(String mess) {
        if (LOGE) {
            Log.e((String)LogUtil.getTag(), (String)LogUtil.getMsgFormat(mess));
        }
    }

    private static String getFunctionName() {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts != null) {
            for (StackTraceElement st : sts) {
                if (st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(LogUtil.class.getName())) continue;
                return "[ Thread:" + Thread.currentThread().getName() + ", at " + st.getClassName() + "." + st.getMethodName() + "(" + st.getFileName() + ":" + st.getLineNumber() + ") ]";
            }
        }
        return null;
    }

    private static String getMsgFormat(String msg) {
        return msg + " \n--- " + LogUtil.getFunctionName();
    }
}

