/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.mvvmquick.util;

import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.xujiaji.mvvmquick.util.ScreenUtils;
import dagger.internal.Preconditions;

public class ActivityUtils {
    private static long exitTime = 0L;

    public static void replaceFragmentInActivity(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, int frameId) {
        ActivityUtils.replaceFragmentInActivity(fragmentManager, fragment, frameId, null, null);
    }

    public static void replaceFragmentInActivity(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, int frameId, String tag, String toBackStackStr) {
        Preconditions.checkNotNull((Object)fragmentManager);
        Preconditions.checkNotNull((Object)fragment);
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        if (TextUtils.isEmpty((CharSequence)tag)) {
            transaction.replace(frameId, fragment);
        } else {
            transaction.replace(frameId, fragment, tag);
        }
        if (!TextUtils.isEmpty((CharSequence)toBackStackStr)) {
            transaction.addToBackStack(toBackStackStr);
        }
        transaction.commit();
    }

    public static void addFragmentInActivity(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, int frameId, String tag) {
        Preconditions.checkNotNull((Object)fragmentManager);
        Preconditions.checkNotNull((Object)fragment);
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        transaction.add(frameId, fragment, tag);
        transaction.commit();
    }

    public static boolean exitBy2Click() {
        return ActivityUtils.exitBy2Click(2000);
    }

    public static boolean exitBy2Click(int space) {
        if (System.currentTimeMillis() - exitTime > 2000L) {
            exitTime = System.currentTimeMillis();
            return false;
        }
        return true;
    }

    public static void initSatus(View view) {
        int statusHeight = ScreenUtils.getStatusHeight(view.getContext());
        ViewGroup.LayoutParams statusParams = view.getLayoutParams();
        statusParams.height = statusHeight;
        view.setLayoutParams(statusParams);
    }
}

