/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.mvvmquick.base;

import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.xujiaji.mvvmquick.R;
import com.xujiaji.mvvmquick.base.MQViewHolder;
import com.xujiaji.mvvmquick.base.MQViewModel;
import java.util.List;

public abstract class MQQuickAdapter<T, B extends ViewDataBinding>
extends BaseQuickAdapter<T, MQViewHolder<B>>
implements BaseQuickAdapter.RequestLoadMoreListener {
    private boolean loaded = false;

    public MQQuickAdapter(int layoutResId) {
        super(layoutResId);
    }

    public MQQuickAdapter(@Nullable List<T> data) {
        super(data);
    }

    public MQQuickAdapter(int layoutResId, @Nullable List<T> data) {
        super(layoutResId, data);
    }

    protected View getItemView(int layoutResId, ViewGroup parent) {
        if (layoutResId != this.mLayoutResId) {
            return super.getItemView(layoutResId, parent);
        }
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)this.mLayoutInflater, (int)layoutResId, (ViewGroup)parent, (boolean)false);
        this.onBinding(binding);
        View view = binding.getRoot();
        view.setTag(R.id.BaseQuickAdapter_databinding_support, (Object)binding);
        return view;
    }

    protected abstract void onBinding(B var1);

    public void bindToRecyclerView(RecyclerView recyclerView, boolean load) {
        super.bindToRecyclerView(recyclerView);
        if (load) {
            this.setOnLoadMoreListener(this, recyclerView);
        }
    }

    public void onLoadMoreRequested() {
        if (this.loaded) {
            this.loadMoreEnd();
            return;
        }
        MQViewModel viewModel = this.getViewModel();
        if (viewModel == null) {
            return;
        }
        viewModel.onListLoad(viewModel.getLoadOffset());
    }

    @Nullable
    protected MQViewModel getViewModel() {
        return null;
    }

    public void setLoaded() {
        this.loaded = true;
    }
}

