/*
 * Decompiled with CFR 0.152.
 */
package com.github.xujiaji.mk.security.admin.service;

import com.github.xujiaji.mk.common.entity.BaseEntity;
import com.github.xujiaji.mk.common.entity.IUser;
import com.github.xujiaji.mk.common.service.IUserInfoService;
import com.github.xujiaji.mk.security.entity.MkSecUser;
import com.github.xujiaji.mk.security.mapper.MkSecPermissionMapper;
import com.github.xujiaji.mk.security.mapper.MkSecRoleMapper;
import com.github.xujiaji.mk.security.mapper.MkSecUserMapper;
import com.github.xujiaji.mk.security.vo.UserPrincipal;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class CustomUserDetailsService
implements UserDetailsService {
    @Autowired
    private MkSecUserMapper mkSecUserMapper;
    @Autowired
    private MkSecRoleMapper mkSecRoleMapper;
    @Autowired
    private MkSecPermissionMapper mkSecPermissionMapper;
    @Autowired
    private IUserInfoService userInfoService;

    public UserDetails loadUserByUsername(String secUserId) throws UsernameNotFoundException {
        MkSecUser secUser = (MkSecUser)this.mkSecUserMapper.selectById((Serializable)((Object)secUserId));
        IUser user = this.userInfoService.getUserWithPhoneEmailPassword(secUser.getUserId());
        List secRoles = this.mkSecRoleMapper.selectBySecUserId(Long.valueOf(Long.parseLong(secUserId)));
        List roleIds = secRoles.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List secPermissions = this.mkSecPermissionMapper.selectByRoleIdList(roleIds);
        return UserPrincipal.create((MkSecUser)secUser, (IUser)user, (List)secRoles, (List)secPermissions);
    }
}

