/*
 * Decompiled with CFR 0.152.
 */
package com.github.xujiaji.mk.security.admin.config;

import cn.hutool.core.util.StrUtil;
import com.github.xujiaji.mk.common.base.Consts;
import com.github.xujiaji.mk.common.base.Status;
import com.github.xujiaji.mk.common.entity.BaseEntity;
import com.github.xujiaji.mk.security.entity.MkSecPermission;
import com.github.xujiaji.mk.security.exception.SecurityException;
import com.github.xujiaji.mk.security.mapper.MkSecPermissionMapper;
import com.github.xujiaji.mk.security.mapper.MkSecRoleMapper;
import com.github.xujiaji.mk.security.vo.UserPrincipal;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class RbacAuthorityService {
    @Autowired
    private MkSecRoleMapper mkSecRoleMapper;
    @Autowired
    private MkSecPermissionMapper mkSecPermissionMapper;
    @Autowired
    private RequestMappingHandlerMapping mapping;

    public boolean hasPermission(HttpServletRequest request, Authentication authentication) {
        this.checkRequest(request);
        Object userInfo = authentication.getPrincipal();
        boolean hasPermission = false;
        if (userInfo instanceof UserDetails) {
            UserPrincipal principal = (UserPrincipal)userInfo;
            Long secUserId = principal.getSecUserId();
            List roles = this.mkSecRoleMapper.selectBySecUserId(secUserId);
            List roleIds = roles.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List permissions = this.mkSecPermissionMapper.selectByRoleIdList(roleIds);
            List btnPerms = permissions.stream().filter(permission -> Objects.equals(permission.getType(), Consts.BUTTON)).filter(permission -> StrUtil.isNotBlank((CharSequence)permission.getUrl())).filter(permission -> StrUtil.isNotBlank((CharSequence)permission.getMethod())).collect(Collectors.toList());
            for (MkSecPermission btnPerm : btnPerms) {
                AntPathRequestMatcher antPathMatcher = new AntPathRequestMatcher(btnPerm.getUrl(), btnPerm.getMethod());
                if (!antPathMatcher.matches(request)) continue;
                hasPermission = true;
                break;
            }
            return hasPermission;
        }
        return false;
    }

    private void checkRequest(HttpServletRequest request) {
        String currentMethod = request.getMethod();
        Multimap<String, String> urlMapping = this.allUrlMapping();
        for (String uri : urlMapping.keySet()) {
            AntPathRequestMatcher antPathMatcher = new AntPathRequestMatcher(uri);
            if (!antPathMatcher.matches(request)) continue;
            if (!urlMapping.get((Object)uri).contains(currentMethod)) {
                throw new SecurityException(Status.HTTP_BAD_METHOD);
            }
            return;
        }
        throw new SecurityException(Status.REQUEST_NOT_FOUND);
    }

    private Multimap<String, String> allUrlMapping() {
        ArrayListMultimap urlMapping = ArrayListMultimap.create();
        Map handlerMethods = this.mapping.getHandlerMethods();
        handlerMethods.forEach((arg_0, arg_1) -> RbacAuthorityService.lambda$allUrlMapping$4((Multimap)urlMapping, arg_0, arg_1));
        return urlMapping;
    }

    private static /* synthetic */ void lambda$allUrlMapping$4(Multimap urlMapping, RequestMappingInfo k, HandlerMethod v) {
        Set url = k.getPatternsCondition().getPatterns();
        RequestMethodsRequestCondition method = k.getMethodsCondition();
        url.forEach(s -> urlMapping.putAll(s, (Iterable)method.getMethods().stream().map(Enum::toString).collect(Collectors.toList())));
    }
}

