/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.dmlib2.widget;

import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import android.view.View;
import com.xujiaji.dmlib2.Direction;
import com.xujiaji.dmlib2.LogUtil;
import com.xujiaji.dmlib2.SurfaceProxy;
import com.xujiaji.dmlib2.callback.OnDMAddListener;
import com.xujiaji.dmlib2.entity.BaseDmEntity;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Controller
implements Runnable {
    private Direction mDirection = Direction.RIGHT_LEFT;
    private PriorityQueue<BaseDmEntity> mNewDMQueue = new PriorityQueue();
    private List<BaseDmEntity> mAddedMDList = new LinkedList<BaseDmEntity>();
    private SurfaceProxy mSurfaceProxy;
    private int mWidth;
    private int mHeight;
    private int offset;
    private int hSpace = 20;
    private int vSpace = 20;
    private boolean isRunning;
    private boolean isPause;
    private int span = 5;
    private long sleep = 0L;
    private boolean isH;
    private ExecutorService exec = Executors.newCachedThreadPool();
    private OnDMAddListener mOnDMAddListener;
    private Handler mMainHandler;
    private SparseArray<LinkedList<BaseDmEntity>> hierarchy = new SparseArray();

    void init(int width, int height, SurfaceProxy surfaceProxy) {
        this.mSurfaceProxy = surfaceProxy;
        this.mWidth = width;
        this.mHeight = height;
        this.initOffset();
    }

    void initOffset() {
        switch (this.mDirection) {
            case RIGHT_LEFT: {
                this.offset = this.mWidth;
                if (this.span <= 0) break;
                this.span = -this.span;
                break;
            }
            case LEFT_RIGHT: 
            case UP_DOWN: {
                this.offset = 0;
                if (this.span >= 0) break;
                this.span = -this.span;
                break;
            }
            case DOWN_UP: {
                this.offset = this.mHeight;
                if (this.span <= 0) break;
                this.span = -this.span;
            }
        }
    }

    private Handler getMainHandler() {
        if (this.mMainHandler == null) {
            return new Handler(Looper.getMainLooper());
        }
        return this.mMainHandler;
    }

    @Override
    public void run() {
        while (this.isRunning) {
            this.runTask();
            if (this.sleep == 0L) continue;
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void runTask() {
        this.offset += this.span;
        this.draw(this.offset, false);
        if (!this.addDMInQueue() && this.mAddedMDList.size() == 0) {
            this.isRunning = false;
            if (this.mOnDMAddListener != null) {
                this.getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        Controller.this.mOnDMAddListener.addedAll();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draw(int value, boolean isOnlyClear) {
        Canvas canvas = null;
        try {
            canvas = this.mSurfaceProxy.lockCanvas();
            if (canvas == null) {
            } else {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                if (isOnlyClear) {
                    return;
                }
                canvas.save();
                if (this.isH) {
                    canvas.translate((float)value, 0.0f);
                } else {
                    canvas.translate(0.0f, (float)value);
                }
                Iterator<BaseDmEntity> iterator = this.mAddedMDList.iterator();
                while (iterator.hasNext()) {
                    BaseDmEntity entity = iterator.next();
                    boolean removeThisEntity = false;
                    switch (this.mDirection) {
                        case RIGHT_LEFT: {
                            removeThisEntity = this.offset < -entity.rect.right;
                            break;
                        }
                        case LEFT_RIGHT: {
                            removeThisEntity = this.offset > this.mWidth + entity.rect.right;
                            break;
                        }
                        case DOWN_UP: {
                            removeThisEntity = this.offset < -entity.rect.bottom;
                            break;
                        }
                        case UP_DOWN: {
                            boolean bl = removeThisEntity = this.offset > this.mHeight + entity.rect.bottom;
                        }
                    }
                    if (removeThisEntity) {
                        iterator.remove();
                    }
                    switch (this.mDirection) {
                        case RIGHT_LEFT: 
                        case DOWN_UP: {
                            canvas.drawBitmap(entity.bitmap, (float)entity.rect.left, (float)entity.rect.top, null);
                            break;
                        }
                        case LEFT_RIGHT: {
                            canvas.drawBitmap(entity.bitmap, (float)(-entity.rect.left - entity.rect.width()), (float)entity.rect.top, null);
                            break;
                        }
                        case UP_DOWN: {
                            canvas.drawBitmap(entity.bitmap, (float)entity.rect.left, (float)(-entity.rect.top - entity.rect.height()), null);
                        }
                    }
                }
                canvas.restore();
            }
        }
        catch (Exception e) {
            LogUtil.i(e.getMessage());
        }
        finally {
            if (canvas != null) {
                this.mSurfaceProxy.unlockCanvasAndPost(canvas);
            }
        }
    }

    public synchronized void add(final View templateView) {
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                BaseDmEntity entity = new BaseDmEntity(templateView);
                Controller.this.addToQueue(entity);
            }
        });
    }

    public synchronized void addToQueue(BaseDmEntity entity) {
        if (entity == null) {
            throw new RuntimeException("entity cannot null");
        }
        this.mNewDMQueue.add(entity);
        if (!this.isRunning) {
            this.start();
        }
    }

    private boolean addDMInQueue() {
        int maxLimit;
        int minLimit;
        BaseDmEntity entity = this.mNewDMQueue.peek();
        if (entity == null) {
            return false;
        }
        switch (this.mDirection) {
            case RIGHT_LEFT: {
                minLimit = this.mWidth - this.offset;
                maxLimit = minLimit + this.mWidth;
                break;
            }
            case LEFT_RIGHT: {
                minLimit = this.offset;
                maxLimit = minLimit + this.mWidth;
                break;
            }
            case DOWN_UP: {
                minLimit = this.mHeight - this.offset;
                maxLimit = minLimit + this.mHeight;
                break;
            }
            case UP_DOWN: {
                minLimit = this.offset;
                maxLimit = minLimit + this.mHeight;
                break;
            }
            default: {
                minLimit = 0;
                maxLimit = 0;
            }
        }
        if (this.mAddedMDList.size() == 0) {
            this.addToDisplay(entity);
            return true;
        }
        if (this.isH) {
            for (BaseDmEntity addedDM : this.mAddedMDList) {
                if (this.hierarchy.get(addedDM.rect.top) == null) {
                    this.hierarchy.put(addedDM.rect.top, new LinkedList());
                }
                ((LinkedList)this.hierarchy.get(addedDM.rect.top)).addFirst(addedDM);
            }
        } else {
            for (BaseDmEntity addedDM : this.mAddedMDList) {
                if (this.hierarchy.get(addedDM.rect.left) == null) {
                    this.hierarchy.put(addedDM.rect.left, new LinkedList());
                }
                ((LinkedList)this.hierarchy.get(addedDM.rect.left)).addFirst(addedDM);
            }
        }
        BaseDmEntity lastDm = null;
        for (int i = 0; i < this.hierarchy.size(); ++i) {
            LinkedList linkedList = (LinkedList)this.hierarchy.get(this.hierarchy.keyAt(i));
            if (linkedList.size() == 0) continue;
            BaseDmEntity lastEntity = (BaseDmEntity)linkedList.getFirst();
            if (this.isH) {
                if (lastDm == null && lastEntity.rect.top >= lastEntity.rect.height() + this.vSpace) {
                    entity.rect.offsetTo(minLimit, 0);
                    this.addToDisplay(entity);
                    return true;
                }
            } else if (lastDm == null && lastEntity.rect.left >= lastEntity.rect.width() + this.hSpace) {
                entity.rect.offsetTo(0, minLimit);
                this.addToDisplay(entity);
                return true;
            }
            if (this.isH) {
                if (lastDm != null && lastDm.rect.bottom + lastEntity.rect.height() < lastEntity.rect.top) {
                    entity.rect.offsetTo(minLimit, lastDm.rect.bottom + this.vSpace);
                    this.addToDisplay(entity);
                    return true;
                }
            } else if (lastDm != null && lastDm.rect.right + lastEntity.rect.width() < lastEntity.rect.left) {
                entity.rect.offsetTo(lastDm.rect.right + this.hSpace, minLimit);
                this.addToDisplay(entity);
                return true;
            }
            lastDm = lastEntity;
            if (this.isH) {
                if (lastEntity.rect.right >= maxLimit) continue;
                entity.rect.offsetTo((lastEntity.rect.right > minLimit ? lastEntity.rect.right : minLimit) + this.hSpace, lastEntity.rect.top);
                this.addToDisplay(entity);
                return true;
            }
            if (lastEntity.rect.bottom >= maxLimit) continue;
            entity.rect.offsetTo(lastEntity.rect.left, (lastEntity.rect.bottom > minLimit ? lastEntity.rect.bottom : minLimit) + this.vSpace);
            this.addToDisplay(entity);
            return true;
        }
        if (lastDm == null) {
            throw new RuntimeException("lastDm can not null");
        }
        if (this.isH) {
            if (lastDm.rect.bottom < this.mHeight - lastDm.rect.height()) {
                entity.rect.offsetTo(minLimit, lastDm.rect.bottom + this.vSpace);
                this.addToDisplay(entity);
                return true;
            }
        } else if (lastDm.rect.right < this.mWidth - lastDm.rect.width()) {
            entity.rect.offsetTo(lastDm.rect.right + this.hSpace, minLimit);
            this.addToDisplay(entity);
            return true;
        }
        return false;
    }

    private void addToDisplay(final BaseDmEntity entity) {
        this.mNewDMQueue.remove(entity);
        this.mAddedMDList.add(entity);
        this.hierarchy.clear();
        if (this.mOnDMAddListener != null) {
            this.getMainHandler().post(new Runnable(){

                @Override
                public void run() {
                    Controller.this.mOnDMAddListener.added(entity);
                }
            });
        }
    }

    public void setOnDMAddListener(OnDMAddListener l) {
        this.mOnDMAddListener = l;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.initOffset();
        this.isRunning = true;
        new Thread(this).start();
    }

    public void prepare() {
        if (this.isPause) {
            this.isPause = false;
            this.isRunning = true;
            new Thread(this).start();
        }
    }

    public void pause() {
        this.isPause = true;
        this.isRunning = false;
    }

    public void destroy() {
        this.mMainHandler = null;
        this.isPause = false;
        this.isRunning = false;
        this.mNewDMQueue.clear();
        this.mAddedMDList.clear();
        this.initOffset();
        this.draw(0, true);
    }

    public void setDirection(Direction mDirection) {
        this.mDirection = mDirection;
        this.isH = mDirection == Direction.LEFT_RIGHT || mDirection == Direction.RIGHT_LEFT;
    }

    public void sethSpace(int hSpace) {
        this.hSpace = hSpace;
    }

    public void setvSpace(int vSpace) {
        this.vSpace = vSpace;
    }

    public void setSpan(int span) {
        if (span == 0) {
            span = 2;
        }
        this.span = span;
    }

    public void setSleep(long sleep) {
        this.sleep = sleep;
    }
}

