/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.dmlib2.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.xujiaji.dmlib2.DM;
import com.xujiaji.dmlib2.Direction;
import com.xujiaji.dmlib2.R;
import com.xujiaji.dmlib2.SurfaceProxy;
import com.xujiaji.dmlib2.Util;
import com.xujiaji.dmlib2.widget.Controller;

public class DMSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback,
DM {
    private SurfaceHolder mSurfaceHolder;
    private Controller mController = new Controller();
    private int mWidth;
    private int mHeight;

    public DMSurfaceView(Context context) {
        this(context, null);
    }

    public DMSurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DMSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initHolder();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DMSurfaceView, defStyleAttr, 0);
        Direction direction = Direction.getType(a.getInt(R.styleable.DMSurfaceView_dm_direction, Direction.RIGHT_LEFT.value));
        int span = a.getDimensionPixelOffset(R.styleable.DMSurfaceView_dm_span, Util.dp2px(context, 2.0f));
        int sleep = a.getInteger(R.styleable.DMSurfaceView_dm_sleep, 0);
        int vSpace = a.getDimensionPixelOffset(R.styleable.DMSurfaceView_dm_v_space, Util.dp2px(context, 10.0f));
        int hSpace = a.getDimensionPixelOffset(R.styleable.DMSurfaceView_dm_h_space, Util.dp2px(context, 10.0f));
        a.recycle();
        this.mController.setDirection(direction);
        this.mController.sethSpace(hSpace);
        this.mController.setvSpace(vSpace);
        this.mController.setSpan(span);
        this.mController.setSleep(sleep);
    }

    private void initHolder() {
        this.mSurfaceHolder = this.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.setZOrderOnTop(true);
        this.mSurfaceHolder.setFormat(-2);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mController.prepare();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mWidth == width && this.mHeight == height) {
            return;
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mController.init(width, height, new SurfaceProxy(this.mSurfaceHolder));
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.mController.prepare();
        } else {
            this.mController.pause();
            this.mController.draw(0, true);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mController.pause();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mController.destroy();
    }

    @Override
    public Controller getController() {
        return this.mController;
    }
}

