/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system.bt;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.xuexiang.xutil.XUtil;
import com.xuexiang.xutil.common.StringUtils;
import com.xuexiang.xutil.system.ThreadPoolManager;
import com.xuexiang.xutil.system.bt.IBluetoothDeviceFilter;
import com.xuexiang.xutil.tip.ToastUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class BluetoothHelper {
    private static volatile BluetoothHelper sInstance;
    private volatile BlueToothReceiver mReceiver;
    private boolean mNeed2unRegister = false;
    private BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    private List<BluetoothDevice> mBondedList;
    private List<BluetoothDevice> mNewList;
    private OnBluetoothDeviceListener mOnBluetoothDeviceListener;
    private IBluetoothDeviceFilter mBluetoothDeviceFilter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BluetoothHelper get() {
        if (sInstance != null) return sInstance;
        Class<BluetoothHelper> clazz = BluetoothHelper.class;
        synchronized (BluetoothHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new BluetoothHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private BluetoothHelper() {
    }

    private void registerBTReceiver() {
        if (this.mReceiver == null) {
            this.mReceiver = new BlueToothReceiver();
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.device.action.FOUND");
        intentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        XUtil.getContext().getApplicationContext().registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter);
        this.mNeed2unRegister = true;
    }

    public void openBluetooth(final boolean isReOpen) {
        ThreadPoolManager.get().addTask(new Runnable(){
            boolean openResult;

            @Override
            public void run() {
                this.openResult = isReOpen ? BluetoothHelper.this.reOpenBluetooth() : BluetoothHelper.this.openBluetooth();
                if (this.openResult && BluetoothHelper.this.mOnBluetoothDeviceListener != null) {
                    if (isReOpen) {
                        BluetoothHelper.this.mOnBluetoothDeviceListener.onBluetoothReOpened();
                    } else {
                        BluetoothHelper.this.mOnBluetoothDeviceListener.onBluetoothOpened();
                    }
                }
            }
        });
    }

    private boolean openBluetooth() {
        boolean result = false;
        if (this.mBluetoothAdapter != null) {
            if (this.mBluetoothAdapter.isEnabled()) {
                return true;
            }
            result = this.enableBluetooth();
        }
        return result;
    }

    private boolean reOpenBluetooth() {
        if (this.mBluetoothAdapter.isEnabled()) {
            this.mBluetoothAdapter.disable();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.enableBluetooth();
    }

    private boolean enableBluetooth() {
        boolean result = false;
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.enable();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.mBluetoothAdapter.isEnabled()) {
                result = true;
            }
        }
        return result;
    }

    public boolean startSearch() {
        this.stopSearch();
        return this.mBluetoothAdapter.startDiscovery();
    }

    public void stopSearch() {
        if (this.mBluetoothAdapter == null) {
            return;
        }
        if (this.mBluetoothAdapter.isDiscovering()) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
    }

    public void searchDevices(OnBluetoothDeviceListener listener) {
        this.mOnBluetoothDeviceListener = listener;
        if (this.mBluetoothAdapter == null) {
            return;
        }
        this.registerBTReceiver();
        if (this.mBondedList == null) {
            this.mBondedList = new ArrayList<BluetoothDevice>();
        }
        if (this.mNewList == null) {
            this.mNewList = new ArrayList<BluetoothDevice>();
        }
        this.mBondedList.clear();
        this.mNewList.clear();
        if (this.startSearch()) {
            if (this.mOnBluetoothDeviceListener != null) {
                this.mOnBluetoothDeviceListener.onStartDiscovery();
            }
        } else {
            ToastUtils.toast((String)"\u84dd\u7259\u626b\u63cf\u5f02\u5e38\uff0c\u6b63\u5728\u91cd\u8bd5");
            this.openBluetooth(true);
        }
    }

    public boolean createBind(BluetoothDevice btDevice) throws Exception {
        Method createBondMethod = btDevice.getClass().getMethod("createBond", new Class[0]);
        Boolean returnValue = (Boolean)createBondMethod.invoke((Object)btDevice, new Object[0]);
        return returnValue;
    }

    @SuppressLint(value={"NewApi"})
    public boolean createBind(BluetoothDevice btDevice, String pingCode) {
        btDevice.setPin(pingCode.getBytes());
        return btDevice.createBond();
    }

    @SuppressLint(value={"NewApi"})
    public boolean pairBtDevice(String address) {
        BluetoothDevice device;
        boolean result = false;
        this.stopSearch();
        if (!this.mBluetoothAdapter.isEnabled()) {
            this.mBluetoothAdapter.enable();
        }
        if (BluetoothAdapter.checkBluetoothAddress((String)address) && this.isCorrectDevice(device = this.getBluetoothDevice(address))) {
            result = device.getBondState() == 12 || device.createBond();
        }
        return result;
    }

    public boolean isOpenBluetooth() {
        return this.mBluetoothAdapter.isEnabled();
    }

    public boolean isBtAddressValid(String address) {
        return !StringUtils.isEmpty((CharSequence)address) && BluetoothAdapter.checkBluetoothAddress((String)address.toUpperCase());
    }

    public boolean isCorrectDevice(String address) {
        return this.isCorrectDevice(this.getBluetoothDevice(address));
    }

    public boolean isCorrectDevice(BluetoothDevice device) {
        boolean isCorrectDevice = true;
        if (this.mBluetoothDeviceFilter != null) {
            isCorrectDevice = this.mBluetoothDeviceFilter.isCorrect(device);
        }
        return isCorrectDevice;
    }

    public boolean isBluetoothBond(String address) {
        BluetoothDevice device = this.getBluetoothDevice(address);
        return device.getBondState() == 12;
    }

    public void release() {
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
        if (this.mNeed2unRegister) {
            XUtil.getContext().getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mReceiver);
            this.mNeed2unRegister = false;
        }
        this.mNewList = null;
        this.mBondedList = null;
        this.mOnBluetoothDeviceListener = null;
        this.mReceiver = null;
        this.mBluetoothDeviceFilter = null;
    }

    public BluetoothHelper setOnBluetoothDeviceListener(OnBluetoothDeviceListener listener) {
        this.mOnBluetoothDeviceListener = listener;
        return this;
    }

    public BluetoothHelper setBluetoothDeviceFilter(IBluetoothDeviceFilter deviceFilter) {
        this.mBluetoothDeviceFilter = deviceFilter;
        return this;
    }

    public IBluetoothDeviceFilter getBluetoothDeviceFilter() {
        return this.mBluetoothDeviceFilter;
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.mBluetoothAdapter;
    }

    public BluetoothDevice getBluetoothDevice(String address) {
        if (this.mBluetoothAdapter != null) {
            return this.mBluetoothAdapter.getRemoteDevice(address);
        }
        return BluetoothAdapter.getDefaultAdapter().getRemoteDevice(address);
    }

    public static interface OnSearchDeviceListener {
        public void onStartDiscovery();

        public void onNewDeviceFound(BluetoothDevice var1);

        public void onSearchCompleted(List<BluetoothDevice> var1, List<BluetoothDevice> var2);
    }

    public static interface OnBluetoothDeviceListener
    extends OnSearchDeviceListener {
        public void onBondStateChanged(BluetoothDevice var1, Intent var2);

        public void onBluetoothOpened();

        public void onBluetoothReOpened();
    }

    private class BlueToothReceiver
    extends BroadcastReceiver {
        private BlueToothReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (BluetoothHelper.this.isCorrectDevice(device)) {
                    if (BluetoothHelper.this.mOnBluetoothDeviceListener != null) {
                        BluetoothHelper.this.mOnBluetoothDeviceListener.onNewDeviceFound(device);
                    }
                    if (device.getBondState() == 10) {
                        BluetoothHelper.this.mNewList.add(device);
                    } else if (device.getBondState() == 12) {
                        BluetoothHelper.this.mBondedList.add(device);
                    }
                }
            } else if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (BluetoothHelper.this.mOnBluetoothDeviceListener != null) {
                    BluetoothHelper.this.mOnBluetoothDeviceListener.onBondStateChanged(device, intent);
                }
            } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action) && BluetoothHelper.this.mOnBluetoothDeviceListener != null) {
                BluetoothHelper.this.mOnBluetoothDeviceListener.onSearchCompleted(BluetoothHelper.this.mBondedList, BluetoothHelper.this.mNewList);
            }
        }
    }
}

