/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system.bt;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.CountDownTimer;
import com.xuexiang.xutil.system.ThreadPoolManager;
import com.xuexiang.xutil.system.bt.IBluetoothDeviceFilter;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"NewApi"})
public final class BLEHelper {
    private static final int DEFAULT_CONNECT_TIMEOUT = 15;
    private static volatile BLEHelper sInstance;
    private BluetoothAdapter mBluetoothAdapter;
    private List<BluetoothDevice> mBondedList;
    private List<BluetoothDevice> mNewList;
    private OnSearchDeviceListener mListener;
    private IBluetoothDeviceFilter mBluetoothDeviceFilter;
    private BLESearchCountDownTimer mTimeOutTimer;
    private long mTimeout = 15L;
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            if (BLEHelper.this.isCorrectDevice(device)) {
                if (device.getBondState() == 10) {
                    if (BLEHelper.this.mNewList != null) {
                        BLEHelper.this.mNewList.add(device);
                    }
                } else if (device.getBondState() == 12 && BLEHelper.this.mBondedList != null) {
                    BLEHelper.this.mBondedList.add(device);
                }
                if (BLEHelper.this.mListener != null && BLEHelper.this.mListener.onNewDeviceFound(device)) {
                    BLEHelper.this.stopSearch();
                    BLEHelper.this.mListener.onSearchCompleted(BLEHelper.this.mBondedList, BLEHelper.this.mNewList);
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BLEHelper get() {
        if (sInstance != null) return sInstance;
        Class<BLEHelper> clazz = BLEHelper.class;
        synchronized (BLEHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new BLEHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private BLEHelper() {
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public BLEHelper setTimeout(long timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public void startScanListener() {
        if (this.mTimeOutTimer == null) {
            this.mTimeOutTimer = new BLESearchCountDownTimer(this.mTimeout);
        }
        this.mTimeOutTimer.start();
    }

    public void cancelScanListener() {
        if (this.mTimeOutTimer != null) {
            this.mTimeOutTimer.cancel();
            this.mTimeOutTimer = null;
        }
    }

    public boolean isCorrectDevice(BluetoothDevice device) {
        boolean isCorrectDevice = true;
        if (this.mBluetoothDeviceFilter != null) {
            isCorrectDevice = this.mBluetoothDeviceFilter.isCorrect(device);
        }
        return isCorrectDevice;
    }

    public void openBluetooth() {
        this.openBluetooth(null);
    }

    public void openBluetooth(final OnBluetoothOpenListener listener) {
        ThreadPoolManager.get().addTask(new Runnable(){

            @Override
            public void run() {
                boolean openResult = BLEHelper.this.getOpenBluetoothResult();
                if (openResult && listener != null) {
                    listener.onBluetoothOpened();
                }
            }
        });
    }

    private boolean getOpenBluetoothResult() {
        boolean result = false;
        if (this.mBluetoothAdapter != null) {
            if (this.mBluetoothAdapter.isEnabled()) {
                return true;
            }
            result = this.enableBluetooth();
        }
        return result;
    }

    private boolean enableBluetooth() {
        boolean result = false;
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.enable();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.mBluetoothAdapter.isEnabled()) {
                result = true;
            }
        }
        return result;
    }

    public void startSearch() {
        this.stopSearch();
        this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
        this.startScanListener();
    }

    public void stopSearch() {
        if (this.mBluetoothAdapter == null) {
            return;
        }
        this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        this.cancelScanListener();
    }

    public void searchDevices(OnSearchDeviceListener listener) {
        this.mListener = listener;
        if (this.mBluetoothAdapter == null) {
            return;
        }
        if (this.mBondedList == null) {
            this.mBondedList = new ArrayList<BluetoothDevice>();
        }
        if (this.mNewList == null) {
            this.mNewList = new ArrayList<BluetoothDevice>();
        }
        this.mBondedList.clear();
        this.mNewList.clear();
        this.startSearch();
        if (this.mListener != null) {
            this.mListener.onStartDiscovery();
        }
    }

    public void release() {
        this.stopSearch();
        this.mNewList = null;
        this.mBondedList = null;
        this.mListener = null;
        this.mBluetoothDeviceFilter = null;
    }

    public boolean isOpenBluetooth() {
        return this.mBluetoothAdapter.isEnabled();
    }

    public BLEHelper setOnSearchDeviceListener(OnSearchDeviceListener listener) {
        this.mListener = listener;
        return this;
    }

    public BLEHelper setBluetoothDeviceFilter(IBluetoothDeviceFilter deviceFilter) {
        this.mBluetoothDeviceFilter = deviceFilter;
        return this;
    }

    public IBluetoothDeviceFilter getBluetoothDeviceFilter() {
        return this.mBluetoothDeviceFilter;
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.mBluetoothAdapter;
    }

    public BluetoothDevice getBluetoothDevice(String address) {
        if (this.mBluetoothAdapter != null) {
            return this.mBluetoothAdapter.getRemoteDevice(address);
        }
        return BluetoothAdapter.getDefaultAdapter().getRemoteDevice(address);
    }

    public static interface OnBluetoothOpenListener {
        public void onBluetoothOpened();
    }

    public static interface OnSearchDeviceListener {
        public void onStartDiscovery();

        public boolean onNewDeviceFound(BluetoothDevice var1);

        public void onSearchCompleted(List<BluetoothDevice> var1, List<BluetoothDevice> var2);
    }

    private class BLESearchCountDownTimer
    extends CountDownTimer {
        public BLESearchCountDownTimer(long timeout) {
            super(timeout * 1000L, 1000L);
        }

        public void onTick(long millisUntilFinished) {
        }

        public void onFinish() {
            BLEHelper.this.stopSearch();
            if (BLEHelper.this.mListener != null) {
                BLEHelper.this.mListener.onSearchCompleted(BLEHelper.this.mBondedList, BLEHelper.this.mNewList);
            }
        }
    }
}

