/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Properties;

public final class RomUtils {
    public static final String SYS_EMUI = "emui";
    public static final String SYS_MIUI = "miui";
    public static final String SYS_FLYME = "flyme";
    public static final String SYS_COLOROS = "colorOs";
    public static final String SYS_FUNTOUCH = "Funtouch";
    public static final String SYS_SAMSUNG = "samsung";
    private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_MIUI_INTERNAL_STORAGE = "ro.miui.internal.storage";
    private static final String KEY_MIUI_VERSION_INCREMENTAL = "ro.build.version.incremental";
    private static final String KEY_EMUI_API_LEVEL = "ro.build.hw_emui_api_level";
    private static final String KEY_EMUI_VERSION = "ro.build.version.emui";
    private static final String KEY_EMUI_CONFIG_HW_SYS_VERSION = "ro.confg.hw_systemversion";
    private static final String KEY_OPPO_NAME = "ro.rom.different.version";
    private static final String KEY_OPPO_VERSION = "ro.build.version.opporom";
    private static final String KEY_VIVO_NAME = "ro.vivo.os.name";
    private static final String KEY_VIVO_VERSION = "ro.vivo.os.version";
    private static RomBean bean = null;

    public static RomBean getRom() {
        if (bean != null) {
            return bean;
        }
        bean = new RomBean();
        if (!(TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty(KEY_MIUI_VERSION_CODE)) && TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty(KEY_MIUI_VERSION_NAME)) && TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty(KEY_MIUI_INTERNAL_STORAGE)))) {
            RomUtils.bean.setRomName(SYS_MIUI);
            RomUtils.bean.setRomVersion(RomUtils.getSystemProperty(KEY_MIUI_VERSION_INCREMENTAL));
        } else if (!(TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty(KEY_EMUI_API_LEVEL)) && TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty(KEY_EMUI_VERSION)) && TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty(KEY_EMUI_CONFIG_HW_SYS_VERSION)))) {
            RomUtils.bean.setRomName(SYS_EMUI);
            String version = RomUtils.getSystemProperty(KEY_EMUI_VERSION);
            String[] temp = version.split("_");
            if (temp.length > 1) {
                RomUtils.bean.setRomVersion(temp[1]);
            } else {
                RomUtils.bean.setRomVersion(version);
            }
        } else {
            if (Build.DISPLAY.toLowerCase().contains(SYS_FLYME)) {
                RomUtils.bean.setRomName(SYS_FLYME);
                RomUtils.bean.setRomVersion(Build.DISPLAY);
                return bean;
            }
            if (!TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty(KEY_OPPO_NAME)) && RomUtils.getSystemProperty(KEY_OPPO_NAME).toLowerCase().contains("coloros")) {
                RomUtils.bean.setRomName(SYS_COLOROS);
                RomUtils.bean.setRomVersion(RomUtils.getSystemProperty(KEY_OPPO_VERSION));
            } else if (!TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty(KEY_VIVO_NAME))) {
                RomUtils.bean.setRomName(SYS_FUNTOUCH);
                RomUtils.bean.setRomVersion(RomUtils.getSystemProperty(KEY_VIVO_VERSION));
            } else {
                String brand = Build.BRAND;
                RomUtils.bean.setRomName(Build.BRAND);
                if (SYS_SAMSUNG.equalsIgnoreCase(brand)) {
                    RomUtils.bean.setRomVersion(RomUtils.getSystemProperty("ro.build.changelist"));
                }
            }
        }
        return bean;
    }

    private static String getSystemProperty(String name) {
        String prop = RomUtils.getSystemPropertyByShell(name);
        if (!TextUtils.isEmpty((CharSequence)prop)) {
            return prop;
        }
        prop = RomUtils.getSystemPropertyByStream(name);
        if (!TextUtils.isEmpty((CharSequence)prop)) {
            return prop;
        }
        if (Build.VERSION.SDK_INT < 28) {
            return RomUtils.getSystemPropertyByReflect(name);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemPropertyByShell(String propName) {
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            String string = input.readLine();
            return string;
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getSystemPropertyByStream(String key) {
        try {
            Properties prop = new Properties();
            FileInputStream is = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            prop.load(is);
            return prop.getProperty(key, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getSystemPropertyByReflect(String key) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method get = clz.getMethod("get", String.class, String.class);
            return (String)get.invoke(clz, key, "");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static class RomBean {
        private String romName;
        private String romVersion;

        public String getRomName() {
            if (this.romName == null) {
                return "";
            }
            return this.romName;
        }

        private void setRomName(String romName) {
            this.romName = romName;
        }

        public String getRomVersion() {
            if (this.romVersion == null) {
                return "";
            }
            return this.romVersion;
        }

        private void setRomVersion(String romVersion) {
            this.romVersion = romVersion;
        }

        public String toString() {
            return "romName: " + this.romName + "\nromVersion: " + this.romVersion;
        }
    }
}

