/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresPermission;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import com.xuexiang.xutil.XUtil;
import com.xuexiang.xutil.app.IntentUtils;
import com.xuexiang.xutil.common.StringUtils;
import java.util.ArrayList;

public final class PhoneUtils {
    private PhoneUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isPhone() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm != null && tm.getPhoneType() != 0;
    }

    private static TelephonyManager getTelephonyManager() {
        return (TelephonyManager)XUtil.getContext().getSystemService("phone");
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMEI() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm != null ? tm.getDeviceId() : null;
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMSI() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm != null ? tm.getSubscriberId() : null;
    }

    public static int getPhoneType() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm != null ? tm.getPhoneType() : -1;
    }

    public static boolean isSimCardReady() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm != null && tm.getSimState() == 5;
    }

    public static String getSimOperatorName() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm != null ? tm.getSimOperatorName() : null;
    }

    public static String getSimOperatorByMnc() {
        String operator;
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        String string = operator = tm != null ? tm.getSimOperator() : null;
        if (operator == null) {
            return null;
        }
        switch (operator) {
            case "46000": 
            case "46002": 
            case "46007": {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            case "46001": 
            case "46006": {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            case "46003": 
            case "46005": 
            case "46011": {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return operator;
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getPhoneInfo() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        if (tm == null) {
            return "";
        }
        String str = "";
        str = str + "DeviceId(IMEI) = " + tm.getDeviceId() + "\n";
        str = str + "DeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion() + "\n";
        str = str + "Line1Number = " + tm.getLine1Number() + "\n";
        str = str + "NetworkCountryIso = " + tm.getNetworkCountryIso() + "\n";
        str = str + "NetworkOperator = " + tm.getNetworkOperator() + "\n";
        str = str + "NetworkOperatorName = " + tm.getNetworkOperatorName() + "\n";
        str = str + "NetworkType = " + tm.getNetworkType() + "\n";
        str = str + "PhoneType = " + tm.getPhoneType() + "\n";
        str = str + "SimCountryIso = " + tm.getSimCountryIso() + "\n";
        str = str + "SimOperator = " + tm.getSimOperator() + "\n";
        str = str + "SimOperatorName = " + tm.getSimOperatorName() + "\n";
        str = str + "SimSerialNumber = " + tm.getSimSerialNumber() + "\n";
        str = str + "SimState = " + tm.getSimState() + "\n";
        str = str + "SubscriberId(IMSI) = " + tm.getSubscriberId() + "\n";
        str = str + "VoiceMailNumber = " + tm.getVoiceMailNumber() + "\n";
        return str;
    }

    public static void dial(String phoneNumber) {
        XUtil.getContext().startActivity(IntentUtils.getDialIntent((String)phoneNumber, (boolean)true));
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static void call(String phoneNumber) {
        XUtil.getContext().startActivity(IntentUtils.getCallIntent((String)phoneNumber, (boolean)true));
    }

    public static void sendSms(String phoneNumber, String content) {
        XUtil.getContext().startActivity(IntentUtils.getSendSmsIntent((String)phoneNumber, (String)content, (boolean)true));
    }

    @RequiresPermission(value="android.permission.SEND_SMS")
    public static void sendSmsSilent(String phoneNumber, String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return;
        }
        PendingIntent sentIntent = PendingIntent.getBroadcast((Context)XUtil.getContext(), (int)0, (Intent)new Intent(), (int)0);
        SmsManager smsManager = SmsManager.getDefault();
        if (content.length() >= 70) {
            ArrayList ms = smsManager.divideMessage(content);
            for (String str : ms) {
                smsManager.sendTextMessage(phoneNumber, null, str, sentIntent, null);
            }
        } else {
            smsManager.sendTextMessage(phoneNumber, null, content, sentIntent, null);
        }
    }
}

