/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import com.xuexiang.xutil.XUtil;
import java.io.IOException;

public final class FlashlightUtils {
    private static final String TAG = "FlashlightUtils";
    private Camera mCamera;

    private FlashlightUtils() {
    }

    public static FlashlightUtils getInstance() {
        return LazyHolder.INSTANCE;
    }

    public boolean register() {
        try {
            this.mCamera = Camera.open((int)0);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"register: ", (Throwable)t);
            return false;
        }
        if (this.mCamera == null) {
            Log.e((String)TAG, (String)"register: open camera failed!");
            return false;
        }
        try {
            this.mCamera.setPreviewTexture(new SurfaceTexture(0));
            this.mCamera.startPreview();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void unregister() {
        if (this.mCamera == null) {
            return;
        }
        this.mCamera.stopPreview();
        this.mCamera.release();
    }

    public void setFlashlightOn() {
        if (this.mCamera == null) {
            Log.e((String)TAG, (String)"setFlashlightOn: the utils of flashlight register failed!");
            return;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        if (!"torch".equals(parameters.getFlashMode())) {
            parameters.setFlashMode("torch");
            this.mCamera.setParameters(parameters);
        }
    }

    public void setFlashlightOff() {
        if (this.mCamera == null) {
            Log.e((String)TAG, (String)"setFlashlightOn: the utils of flashlight register failed!");
            return;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        if ("torch".equals(parameters.getFlashMode())) {
            parameters.setFlashMode("off");
            this.mCamera.setParameters(parameters);
        }
    }

    public boolean isFlashlightOn() {
        if (this.mCamera == null) {
            Log.e((String)TAG, (String)"setFlashlightOn: the utils of flashlight register failed!");
            return false;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        return "torch".equals(parameters.getFlashMode());
    }

    public static boolean isFlashlightEnable() {
        return XUtil.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    private static final class LazyHolder {
        private static final FlashlightUtils INSTANCE = new FlashlightUtils();

        private LazyHolder() {
        }
    }
}

