/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system;

import android.os.Vibrator;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import com.xuexiang.xutil.XUtil;

public class EditTextShakeHelper {
    private static EditTextShakeHelper sInstance;
    private Animation mShakeAnimation;
    private Vibrator mShakeVibrator = (Vibrator)XUtil.getContext().getSystemService("vibrator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EditTextShakeHelper get() {
        if (sInstance != null) return sInstance;
        Class<EditTextShakeHelper> clazz = EditTextShakeHelper.class;
        synchronized (EditTextShakeHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new EditTextShakeHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public EditTextShakeHelper() {
        this.mShakeAnimation = new TranslateAnimation(0.0f, 10.0f, 0.0f, 0.0f);
        this.mShakeAnimation.setDuration(300L);
        this.mShakeAnimation.setInterpolator((Interpolator)new CycleInterpolator(8.0f));
    }

    public EditTextShakeHelper setShakeAnimation(Animation shakeAnimation) {
        this.mShakeAnimation = shakeAnimation;
        return this;
    }

    public void shake(EditText ... editTexts) {
        if (editTexts != null && editTexts.length > 0) {
            for (EditText editText : editTexts) {
                editText.startAnimation(this.mShakeAnimation);
            }
            this.mShakeVibrator.vibrate(new long[]{0L, 500L}, -1);
        }
    }
}

