/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DoubleKeyValueMap<K1, K2, V> {
    private ConcurrentHashMap<K1, ConcurrentHashMap<K2, V>> m_k1_k2V_map = new ConcurrentHashMap();

    public void put(K1 key1, K2 key2, V value) {
        if (key1 == null || key2 == null || value == null) {
            return;
        }
        if (this.m_k1_k2V_map.containsKey(key1)) {
            ConcurrentHashMap<Object, V> k2V_map = this.m_k1_k2V_map.get(key1);
            if (k2V_map != null) {
                k2V_map.put(key2, value);
            } else {
                k2V_map = new ConcurrentHashMap();
                k2V_map.put(key2, value);
                this.m_k1_k2V_map.put(key1, k2V_map);
            }
        } else {
            ConcurrentHashMap<K2, V> k2V_map = new ConcurrentHashMap<K2, V>();
            k2V_map.put(key2, value);
            this.m_k1_k2V_map.put(key1, k2V_map);
        }
    }

    public Set<K1> getFirstKeys() {
        return this.m_k1_k2V_map.keySet();
    }

    public ConcurrentHashMap<K2, V> get(K1 key1) {
        return this.m_k1_k2V_map.get(key1);
    }

    public V get(K1 key1, K2 key2) {
        ConcurrentHashMap<K2, V> k2_v = this.m_k1_k2V_map.get(key1);
        return k2_v == null ? null : (V)k2_v.get(key2);
    }

    public Collection<V> getAllValues(K1 key1) {
        ConcurrentHashMap<K2, V> k2_v = this.m_k1_k2V_map.get(key1);
        return k2_v == null ? null : k2_v.values();
    }

    public Collection<V> getAllValues() {
        Set k1Set = this.m_k1_k2V_map.keySet();
        ArrayList<V> result = new ArrayList<V>();
        for (Object k1 : k1Set) {
            Collection<V> values = this.m_k1_k2V_map.get(k1).values();
            result.addAll(values);
        }
        return result;
    }

    public boolean containsKey(K1 key1, K2 key2) {
        return this.m_k1_k2V_map.containsKey(key1) && this.m_k1_k2V_map.get(key1).containsKey(key2);
    }

    public boolean containsKey(K1 key1) {
        return this.m_k1_k2V_map.containsKey(key1);
    }

    public int size() {
        if (this.m_k1_k2V_map.size() == 0) {
            return 0;
        }
        int result = 0;
        for (ConcurrentHashMap<K2, V> k2V_map : this.m_k1_k2V_map.values()) {
            result += k2V_map.size();
        }
        return result;
    }

    public void remove(K1 key1) {
        this.m_k1_k2V_map.remove(key1);
    }

    public void remove(K1 key1, K2 key2) {
        ConcurrentHashMap<K2, V> k2_v = this.m_k1_k2V_map.get(key1);
        if (k2_v != null) {
            k2_v.remove(key2);
            if (k2_v.isEmpty()) {
                this.remove(key1);
            }
        }
    }

    public void clear() {
        if (this.m_k1_k2V_map.size() > 0) {
            for (ConcurrentHashMap<K2, V> k2V_map : this.m_k1_k2V_map.values()) {
                k2V_map.clear();
            }
            this.m_k1_k2V_map.clear();
        }
    }
}

