/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class BCDUtils {
    private BCDUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String bcd2String(byte[] bcd) {
        StringBuilder res = new StringBuilder();
        if (null == bcd) {
            return res.toString();
        }
        for (int n : bcd) {
            if (n < 0) {
                n = 256 + n;
            }
            if ((n = n / 16 * 10 + n % 16) < 10) {
                res.append("0").append(n);
                continue;
            }
            res.append(n);
        }
        return res.toString();
    }

    public static int bcd2Int(byte[] bcd) {
        return BCDUtils.toInt(BCDUtils.bcd2String(bcd), 0);
    }

    public static double bcd2Double(byte[] bcd, String format) {
        int point = BCDUtils.getPointLength(format);
        return (double)BCDUtils.bcd2Int(bcd) / Math.pow(10.0, point);
    }

    public static float bcd2Float(byte[] bcd, String format) {
        int point = BCDUtils.getPointLength(format);
        return (float)((double)BCDUtils.bcd2Int(bcd) / Math.pow(10.0, point));
    }

    public static Date bcd2Date(byte[] bcd, String sFormat) {
        if (bcd == null) {
            return new Date();
        }
        return BCDUtils.string2Date(BCDUtils.bcd2String(bcd), sFormat);
    }

    public static byte[] string2Bcd(String sIn, String formatIn) {
        if (sIn == null) {
            return null;
        }
        StringBuilder s = BCDUtils.formatString(sIn);
        StringBuilder format = BCDUtils.formatString(formatIn);
        byte[] res = null;
        try {
            int len = s.length();
            if (len % 2 != 0) {
                s.insert(0, "0");
            }
            if (format.length() % 2 != 0) {
                format.insert(0, "0");
            }
            int allLength = format.length() / 2;
            byte[] resValue = new byte[len / 2];
            for (int i = 0; i <= len - 2; i += 2) {
                resValue[i / 2] = (byte)((byte)(s.charAt(i) - 48) * 16 + (byte)(s.charAt(i + 1) - 48));
            }
            res = new byte[allLength];
            if (allLength >= resValue.length) {
                System.arraycopy(resValue, 0, res, res.length - resValue.length, resValue.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static byte[] string2Bcd(String sIn) {
        return BCDUtils.string2Bcd(sIn, sIn);
    }

    public static byte[] int2Bcd(int value, String format) {
        return BCDUtils.string2Bcd(String.valueOf(value), format);
    }

    public static byte[] double2Bcd(double value, String format) {
        int point = BCDUtils.getPointLength(format);
        return BCDUtils.int2Bcd((int)(value * Math.pow(10.0, point)), format);
    }

    public static byte[] float2Bcd(float value, String format) {
        int point = BCDUtils.getPointLength(format);
        return BCDUtils.int2Bcd((int)((double)value * Math.pow(10.0, point)), format);
    }

    public static byte[] date2Bcd(Date date, String format) {
        String sDate = BCDUtils.date2String(date, format);
        format = format.replaceAll("[^a-zA-Z0-9]*", "");
        sDate = sDate.replaceAll("[^a-zA-Z0-9]*", "");
        return BCDUtils.string2Bcd(sDate, format);
    }

    private static int getPointLength(String format) {
        int index = format.indexOf(".");
        index = index >= 0 ? ++index : format.length();
        return format.length() - index;
    }

    private static int toInt(String value, int defValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static String date2String(Date date, String type) {
        return BCDUtils.date2String(date, new SimpleDateFormat(type));
    }

    private static String date2String(Date date, DateFormat format) {
        if (date != null && format != null) {
            return format.format(date);
        }
        return "";
    }

    private static Date string2Date(String str, String sFormat) {
        char c;
        int i;
        if (str == null) {
            return null;
        }
        StringBuilder sFormat2Parse = new StringBuilder();
        StringBuilder s2Parse = new StringBuilder();
        for (i = 0; i < sFormat.length(); ++i) {
            c = sFormat.charAt(i);
            if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
            sFormat2Parse.append(c);
        }
        for (i = 0; i < str.length(); ++i) {
            c = str.charAt(i);
            if (c < '0' || c > '9') continue;
            s2Parse.append(c);
        }
        SimpleDateFormat format = new SimpleDateFormat(sFormat2Parse.toString());
        Date date = null;
        try {
            date = format.parse(s2Parse.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    private static StringBuilder formatString(String sIn) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < sIn.length(); ++i) {
            char c = sIn.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z') && (c < 'A' || c > 'Z')) continue;
            s.append(c);
        }
        return s;
    }
}

