/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.common;

import java.math.BigDecimal;

public final class BigDecimalUtils {
    private static final int DEF_DIV_SCALE = 10;

    private BigDecimalUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double substract(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double multiply(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double divide(double v1, double v2) {
        return BigDecimalUtils.divide(v1, v2, 10);
    }

    public static double divide(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static String splitAndFormatMoney(BigDecimal s) {
        return BigDecimalUtils.formatMoney(s, ",");
    }

    public static String formatMoney(BigDecimal s) {
        return BigDecimalUtils.formatMoney(s, "");
    }

    public static String formatMoney(BigDecimal s, String separator) {
        if (null == s) {
            return "0.00";
        }
        if (0.0 == s.doubleValue()) {
            return "0.00";
        }
        boolean is_positive_integer = s.toString().contains("-");
        if (is_positive_integer) {
            s = new BigDecimal(s.toString().substring(1, s.toString().length()));
        }
        String str = s.setScale(2, 4).toString();
        StringBuffer sb = new StringBuffer();
        String[] strs = str.split("\\.");
        int j = 1;
        for (int i = 0; i < strs[0].length(); ++i) {
            char a = strs[0].charAt(strs[0].length() - i - 1);
            sb.append(a);
            if (j % 3 == 0 && i != strs[0].length() - 1) {
                sb.append(separator);
            }
            ++j;
        }
        String str1 = sb.toString();
        StringBuffer sb1 = new StringBuffer();
        for (int i = 0; i < str1.length(); ++i) {
            char a = str1.charAt(str1.length() - 1 - i);
            sb1.append(a);
        }
        sb1.append(".");
        sb1.append(strs[1]);
        String retVal = sb1.toString();
        if (is_positive_integer) {
            retVal = "-" + retVal;
        }
        return retVal;
    }

    public static Boolean compareBigDecimal(String amount, double compare) {
        BigDecimal bigDecimal = new BigDecimal(amount);
        return bigDecimal.compareTo(BigDecimal.valueOf(compare)) != -1;
    }
}

