/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app.router;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.ActivityOptionsCompat;
import com.xuexiang.xutil.app.IntentUtils;
import com.xuexiang.xutil.app.router.RouterCallback;

public class Router {
    public static final int ROUTER_ANIM_ENTER = -1;
    public static final int ROUTER_ANIM_EXIT = -1;
    private Intent intent = new Intent();
    private Activity fromActivity;
    private Fragment fromFragment;
    private android.support.v4.app.Fragment fromFragmentV4;
    private Class<?> to;
    private Bundle data;
    private ActivityOptionsCompat options;
    private int requestCode = -1;
    private int enterAnim = -1;
    private int exitAnim = -1;
    public static final int RES_NONE = -1;
    private static RouterCallback callback;

    private Router() {
    }

    public static Router newIntent(Activity context) {
        Router router = new Router();
        router.fromActivity = context;
        return router;
    }

    public static Router newIntent(Fragment fragment) {
        Router router = new Router();
        router.fromFragment = fragment;
        return router;
    }

    public static Router newIntent(android.support.v4.app.Fragment fragment) {
        Router router = new Router();
        router.fromFragmentV4 = fragment;
        return router;
    }

    public Router to(Class<?> to) {
        this.to = to;
        return this;
    }

    public Router addFlags(int flags) {
        if (this.intent != null) {
            this.intent.addFlags(flags);
        }
        return this;
    }

    public Router putBundle(Bundle data) {
        this.data = data;
        return this;
    }

    public Router putBundleParam(@NonNull String key, Object value) {
        if (this.data == null) {
            this.data = new Bundle();
        }
        this.data = IntentUtils.putBundle((Bundle)this.data, (String)key, (Object)value);
        return this;
    }

    public Router putExtraParam(@NonNull String key, Object value) {
        this.intent = IntentUtils.putExtra((Intent)this.intent, (String)key, (Object)value);
        return this;
    }

    public Router options(ActivityOptionsCompat options) {
        this.options = options;
        return this;
    }

    public Router requestCode(int requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    public Router anim(int enterAnim, int exitAnim) {
        this.enterAnim = enterAnim;
        this.exitAnim = exitAnim;
        return this;
    }

    public void launch() {
        block10: {
            Context context = this.getFromContext();
            try {
                if (this.intent != null && context != null && this.to != null) {
                    if (callback != null) {
                        callback.onBefore(context, this.to);
                    }
                    this.intent.setClass(context, this.to);
                    this.intent.putExtras(this.getBundleData());
                    if (this.options == null) {
                        this.startActivity();
                        if (this.enterAnim > 0 && this.exitAnim > 0) {
                            ((Activity)context).overridePendingTransition(this.enterAnim, this.exitAnim);
                        }
                    } else if (this.requestCode < 0) {
                        ActivityCompat.startActivity((Context)context, (Intent)this.intent, (Bundle)this.options.toBundle());
                    } else {
                        ActivityCompat.startActivityForResult((Activity)((Activity)context), (Intent)this.intent, (int)this.requestCode, (Bundle)this.options.toBundle());
                    }
                    if (callback != null) {
                        callback.onNext(context, this.to);
                    }
                }
            }
            catch (Throwable throwable) {
                if (callback == null) break block10;
                callback.onError(context, this.to, throwable);
            }
        }
    }

    private void startActivity() {
        if (this.requestCode < 0) {
            if (this.fromActivity != null) {
                this.fromActivity.startActivity(this.intent);
            } else if (this.fromFragment != null) {
                this.fromFragment.startActivity(this.intent);
            } else if (this.fromFragmentV4 != null) {
                this.fromFragmentV4.startActivity(this.intent);
            }
        } else if (this.fromActivity != null) {
            this.fromActivity.startActivityForResult(this.intent, this.requestCode);
        } else if (this.fromFragment != null) {
            this.fromFragment.startActivityForResult(this.intent, this.requestCode);
        } else if (this.fromFragmentV4 != null) {
            this.fromFragmentV4.startActivityForResult(this.intent, this.requestCode);
        }
    }

    private Context getFromContext() {
        if (this.fromActivity != null) {
            return this.fromActivity;
        }
        if (this.fromFragment != null) {
            return this.fromFragment.getActivity();
        }
        if (this.fromFragmentV4 != null) {
            return this.fromFragmentV4.getContext();
        }
        return null;
    }

    private Bundle getBundleData() {
        if (this.data == null) {
            this.data = new Bundle();
        }
        return this.data;
    }

    public static void pop(Activity activity) {
        activity.finish();
    }

    public static void setCallback(RouterCallback callback) {
        Router.callback = callback;
    }
}

