/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app.notify.builder;

import com.xuexiang.xutil.app.notify.builder.BaseBuilder;

public class ProgressBuilder
extends BaseBuilder {
    private static final String DEFAULT_FORMAT = "\u8fdb\u5ea6:%d/%d";
    private int mMax = 0;
    private int mProgress = 0;
    private boolean mIndeterminate = false;
    private String mFormat = "\u8fdb\u5ea6:%d/%d";

    public ProgressBuilder setProgress(int max, int progress) {
        this.mMax = max;
        this.mProgress = progress;
        this.setContentText(String.format(DEFAULT_FORMAT, this.mProgress, this.mMax));
        return this;
    }

    public ProgressBuilder setMaxProgress(int max) {
        this.mMax = max;
        return this;
    }

    public ProgressBuilder setIndeterminate(boolean indeterminate) {
        this.mIndeterminate = indeterminate;
        if (this.mIndeterminate) {
            this.mMax = 0;
            this.mProgress = 0;
            this.setContentText(null);
        }
        return this;
    }

    public ProgressBuilder setFormat(String format) {
        this.mFormat = format;
        return this;
    }

    public void updateProgress(int progress, String format, Object ... args) {
        this.mProgress = progress;
        this.mFormat = format;
        this.setContentText(String.format(this.mFormat, args));
    }

    public void updateProgress(int progress) {
        this.mProgress = progress;
        this.setContentText(String.format(DEFAULT_FORMAT, this.mProgress, this.mMax));
    }

    @Override
    protected void afterBuild() {
        this.updateProgress();
        this.getBuilder().setDefaults(0);
        this.getBuilder().setPriority(-1);
    }

    private void updateProgress() {
        this.getBuilder().setProgress(this.mMax, this.mProgress, this.mIndeterminate);
    }
}

