/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app.notify;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import com.xuexiang.xutil.XUtil;
import com.xuexiang.xutil.app.notify.builder.BaseBuilder;
import com.xuexiang.xutil.app.notify.builder.BigPicBuilder;
import com.xuexiang.xutil.app.notify.builder.BigTextBuilder;
import com.xuexiang.xutil.app.notify.builder.CustomViewBuilder;
import com.xuexiang.xutil.app.notify.builder.MailboxBuilder;
import com.xuexiang.xutil.app.notify.builder.ProgressBuilder;

public final class NotificationUtils {
    private static NotificationManager sNotificationManager;

    private NotificationUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static BaseBuilder buildSimple(int id, int smallIcon, CharSequence contentTitle, CharSequence contentText, PendingIntent contentIntent) {
        return ((BaseBuilder)((BaseBuilder)new BaseBuilder().setId(id)).setBaseInfo(smallIcon, contentTitle, contentText)).setContentIntent(contentIntent);
    }

    public static BigPicBuilder buildBigPic(int id, int smallIcon, CharSequence contentTitle, CharSequence summaryText) {
        return (BigPicBuilder)((BaseBuilder)((BaseBuilder)((BaseBuilder)new BigPicBuilder().setId(id)).setSmallIcon(smallIcon)).setContentTitle(contentTitle)).setSummaryText(summaryText);
    }

    public static BigTextBuilder buildBigText(int id, int smallIcon, CharSequence contentTitle, CharSequence contentText) {
        return (BigTextBuilder)((BaseBuilder)new BigTextBuilder().setId(id)).setBaseInfo(smallIcon, contentTitle, contentText);
    }

    public static MailboxBuilder buildMailBox(int id, int smallIcon, CharSequence contentTitle) {
        return (MailboxBuilder)((BaseBuilder)((BaseBuilder)new MailboxBuilder().setId(id)).setSmallIcon(smallIcon)).setContentTitle(contentTitle);
    }

    public static ProgressBuilder buildProgress(int id, int smallIcon, CharSequence contentTitle, int max, int progress) {
        return (ProgressBuilder)((BaseBuilder)((BaseBuilder)new ProgressBuilder().setProgress(max, progress).setId(id)).setSmallIcon(smallIcon)).setContentTitle(contentTitle);
    }

    public static ProgressBuilder buildProgress(int id, int smallIcon, CharSequence contentTitle) {
        return (ProgressBuilder)((BaseBuilder)((BaseBuilder)new ProgressBuilder().setIndeterminate(true).setId(id)).setSmallIcon(smallIcon)).setContentTitle(contentTitle);
    }

    public static CustomViewBuilder buildCustomView(int id, int smallIcon, CharSequence contentTitle, String packageName, int layoutId) {
        return (CustomViewBuilder)((BaseBuilder)((BaseBuilder)new CustomViewBuilder(packageName, layoutId).setId(id)).setSmallIcon(smallIcon)).setContentTitle(contentTitle);
    }

    public static void notify(int id, Notification notification) {
        if (sNotificationManager == null) {
            sNotificationManager = NotificationUtils.getNotificationManager();
        }
        sNotificationManager.notify(id, notification);
    }

    public static void cancel(int id) {
        if (sNotificationManager == null) {
            sNotificationManager = NotificationUtils.getNotificationManager();
        }
        sNotificationManager.cancel(id);
    }

    public static void cancelAll() {
        if (sNotificationManager == null) {
            sNotificationManager = NotificationUtils.getNotificationManager();
        }
        sNotificationManager.cancelAll();
    }

    public static NotificationManager getNotificationManager() {
        return (NotificationManager)XUtil.getContext().getSystemService("notification");
    }

    public static NotificationManager getManager() {
        if (sNotificationManager == null) {
            sNotificationManager = NotificationUtils.getNotificationManager();
        }
        return sNotificationManager;
    }
}

