/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.text.TextUtils;
import com.xuexiang.xutil.common.logger.Logger;

public final class PollingUtils {
    private static final boolean DEBUG = true;
    private static final String TAG = "PollingUtils";

    private PollingUtils() {
        throw new Error("Do not need instantiate!");
    }

    public static boolean isPollingServiceExist(Context context, Class<?> cls) {
        Intent intent = new Intent(context, cls);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x20000000);
        if (pendingIntent != null) {
            Logger.vTag((String)TAG, (String)pendingIntent.toString());
        }
        Logger.vTag((String)TAG, (String)(pendingIntent != null ? "Exist" : "Not exist"));
        return pendingIntent != null;
    }

    public static void startPollingService(Context context, int interval, Class<?> cls) {
        PollingUtils.startPollingService(context, interval, cls, null);
    }

    public static void startPollingService(Context context, int interval, Class<?> cls, String action) {
        AlarmManager manager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, cls);
        if (!TextUtils.isEmpty((CharSequence)action)) {
            intent.setAction(action);
        }
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        long triggerAtTime = SystemClock.elapsedRealtime();
        manager.setRepeating(3, triggerAtTime, (long)(interval * 1000), pendingIntent);
    }

    public static void stopPollingService(Context context, Class<?> cls) {
        PollingUtils.stopPollingService(context, cls, null);
    }

    public static void stopPollingService(Context context, Class<?> cls, String action) {
        AlarmManager manager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, cls);
        if (!TextUtils.isEmpty((CharSequence)action)) {
            intent.setAction(action);
        }
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        manager.cancel(pendingIntent);
    }
}

