/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.xuexiang.xupdate.R;
import com.xuexiang.xupdate.XUpdate;
import com.xuexiang.xupdate._XUpdate;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.proxy.IUpdateProxy;
import com.xuexiang.xupdate.utils.FileUtils;
import java.io.File;
import java.util.List;

public final class UpdateUtils {
    private static final String IGNORE_VERSION = "xupdate_ignore_version";
    private static final String PREFS_FILE = "xupdate_prefs";
    private static final String KEY_XUPDATE = "xupdate";

    private UpdateUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void processUpdateEntity(UpdateEntity updateEntity, @NonNull String result, @NonNull IUpdateProxy updateProxy) throws Exception {
        if (updateEntity != null) {
            if (updateEntity.isHasUpdate()) {
                if (UpdateUtils.isIgnoreVersion(updateProxy.getContext(), updateEntity.getVersionName())) {
                    _XUpdate.onUpdateError(2007);
                } else if (TextUtils.isEmpty((CharSequence)updateEntity.getApkCacheDir())) {
                    _XUpdate.onUpdateError(2008);
                } else {
                    updateProxy.findNewVersion(updateEntity, updateProxy);
                }
            } else {
                _XUpdate.onUpdateError(2004);
            }
        } else {
            _XUpdate.onUpdateError(2006, "json:" + result);
        }
    }

    public static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static boolean checkWifi(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected() && info.getType() == 1;
    }

    public static boolean checkNetwork(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public static int getVersionCode(Context context) {
        PackageInfo packageInfo = UpdateUtils.getPackageInfo(context);
        return packageInfo != null ? packageInfo.versionCode : -1;
    }

    public static String getVersionName(Context context) {
        PackageInfo packageInfo = UpdateUtils.getPackageInfo(context);
        return packageInfo != null ? packageInfo.versionName : "";
    }

    public static int compareVersionName(@NonNull String versionName1, @NonNull String versionName2) {
        if (versionName1.equals(versionName2)) {
            return 0;
        }
        String[] versionArray1 = versionName1.split("\\.");
        String[] versionArray2 = versionName2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        try {
            return (T)new Gson().fromJson(json, classOfT);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toJson(Object src) {
        return new Gson().toJson(src);
    }

    public static int dip2px(int dip, Context context) {
        return (int)((float)dip * UpdateUtils.getDensity(context) + 0.5f);
    }

    private static float getDensity(Context context) {
        return UpdateUtils.getDisplayMetrics((Context)context).density;
    }

    private static DisplayMetrics getDisplayMetrics(Context context) {
        return context.getResources().getDisplayMetrics();
    }

    public static Bitmap drawable2Bitmap(Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private static SharedPreferences getSP(Context context) {
        return context.getSharedPreferences(PREFS_FILE, 0);
    }

    public static void saveIgnoreVersion(Context context, String newVersion) {
        UpdateUtils.getSP(context).edit().putString(IGNORE_VERSION, newVersion).apply();
    }

    public static boolean isIgnoreVersion(Context context, String newVersion) {
        return UpdateUtils.getSP(context).getString(IGNORE_VERSION, "").equals(newVersion);
    }

    @NonNull
    public static String getDisplayUpdateInfo(Context context, @NonNull UpdateEntity updateEntity) {
        String targetSize = UpdateUtils.byte2FitMemorySize(updateEntity.getSize() * 1024L);
        String updateContent = updateEntity.getUpdateContent();
        String updateInfo = "";
        if (!TextUtils.isEmpty((CharSequence)targetSize)) {
            updateInfo = context.getString(R.string.xupdate_lab_new_version_size) + targetSize + "\n";
        }
        if (!TextUtils.isEmpty((CharSequence)updateContent)) {
            updateInfo = updateInfo + updateContent;
        }
        return updateInfo;
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String byte2FitMemorySize(long byteNum) {
        if (byteNum <= 0L) {
            return "";
        }
        if (byteNum < 1024L) {
            return String.format("%.1fB", byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format("%.1fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format("%.1fMB", (double)byteNum / 1048576.0);
        }
        return String.format("%.1fGB", (double)byteNum / 1.073741824E9);
    }

    public static boolean isApkDownloaded(UpdateEntity updateEntity) {
        File appFile = UpdateUtils.getApkFileByUpdateEntity(updateEntity);
        return !TextUtils.isEmpty((CharSequence)updateEntity.getMd5()) && FileUtils.isFileExists(appFile) && _XUpdate.isFileValid(updateEntity.getMd5(), appFile);
    }

    public static File getApkFileByUpdateEntity(UpdateEntity updateEntity) {
        String appName = UpdateUtils.getApkNameByDownloadUrl(updateEntity.getDownloadUrl());
        return new File(updateEntity.getApkCacheDir().concat(File.separator + updateEntity.getVersionName()).concat(File.separator + appName));
    }

    @NonNull
    public static String getApkNameByDownloadUrl(String downloadUrl) {
        if (TextUtils.isEmpty((CharSequence)downloadUrl)) {
            return "temp_" + System.currentTimeMillis() + ".apk";
        }
        String appName = downloadUrl.substring(downloadUrl.lastIndexOf("/") + 1);
        if (!appName.endsWith(".apk")) {
            appName = "temp_" + System.currentTimeMillis() + ".apk";
        }
        return appName;
    }

    public static String getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = UpdateUtils.isSDCardEnable() && context.getExternalCacheDir() != null ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return cachePath + File.separator + uniqueName;
    }

    public static File getDefaultDiskCacheDir() {
        return FileUtils.getFileByPath(UpdateUtils.getDefaultDiskCacheDirPath());
    }

    public static boolean isPrivateApkCacheDir(@NonNull UpdateEntity updateEntity) {
        return FileUtils.isPrivatePath(XUpdate.getContext(), updateEntity.getApkCacheDir());
    }

    public static String getDefaultDiskCacheDirPath() {
        return UpdateUtils.getDiskCacheDir(XUpdate.getContext(), KEY_XUPDATE);
    }

    private static boolean isSDCardEnable() {
        return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable();
    }

    private static PackageInfo getPackageInfo(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppName(Context context) {
        PackageInfo packageInfo = UpdateUtils.getPackageInfo(context);
        return packageInfo != null ? packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString() : "";
    }

    public static Drawable getAppIcon(Context context) {
        PackageInfo packageInfo = UpdateUtils.getPackageInfo(context);
        return packageInfo != null ? packageInfo.applicationInfo.loadIcon(context.getPackageManager()) : null;
    }

    public static boolean isAppOnForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        String packageName = context.getPackageName();
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }
}

