/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.entity;

import android.content.Context;
import android.text.TextUtils;
import android.util.SparseArray;
import com.xuexiang.xupdate.R;

public class UpdateError
extends Throwable {
    private final int mCode;
    private static final SparseArray<String> sMessages = new SparseArray();

    public UpdateError(int code) {
        this(code, null);
    }

    public UpdateError(int code, String message) {
        super(UpdateError.make(code, message));
        this.mCode = code;
    }

    public UpdateError(Throwable e) {
        super(e);
        this.mCode = 5100;
    }

    public int getCode() {
        return this.mCode;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    private static String make(int code, String message) {
        String m = (String)sMessages.get(code);
        if (TextUtils.isEmpty((CharSequence)m)) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)message) || message.equals("null")) {
            return m;
        }
        return m + "(" + message + ")";
    }

    public String getDetailMsg() {
        return "Code:" + this.mCode + ", msg:" + this.getMessage();
    }

    public static void init(Context context) {
        sMessages.append(2000, (Object)context.getString(R.string.xupdate_error_check_net_request));
        sMessages.append(2001, (Object)context.getString(R.string.xupdate_error_check_no_wifi));
        sMessages.append(2002, (Object)context.getString(R.string.xupdate_error_check_no_network));
        sMessages.append(2003, (Object)context.getString(R.string.xupdate_error_check_updating));
        sMessages.append(2004, (Object)context.getString(R.string.xupdate_error_check_no_new_version));
        sMessages.append(2005, (Object)context.getString(R.string.xupdate_error_check_json_empty));
        sMessages.append(2006, (Object)context.getString(R.string.xupdate_error_check_parse));
        sMessages.append(2007, (Object)context.getString(R.string.xupdate_error_check_ignored_version));
        sMessages.append(2008, (Object)context.getString(R.string.xupdate_error_check_apk_cache_dir_empty));
        sMessages.append(3000, (Object)context.getString(R.string.xupdate_error_prompt_unknown));
        sMessages.append(3001, (Object)context.getString(R.string.xupdate_error_prompt_activity_destroy));
        sMessages.append(4000, (Object)context.getString(R.string.xupdate_error_download_failed));
        sMessages.append(4001, (Object)context.getString(R.string.xupdate_error_download_permission_denied));
        sMessages.append(5000, (Object)context.getString(R.string.xupdate_error_install_failed));
    }

    public static final class ERROR {
        public static final int CHECK_NET_REQUEST = 2000;
        public static final int CHECK_NO_WIFI = 2001;
        public static final int CHECK_NO_NETWORK = 2002;
        public static final int CHECK_UPDATING = 2003;
        public static final int CHECK_NO_NEW_VERSION = 2004;
        public static final int CHECK_JSON_EMPTY = 2005;
        public static final int CHECK_PARSE = 2006;
        public static final int CHECK_IGNORED_VERSION = 2007;
        public static final int CHECK_APK_CACHE_DIR_EMPTY = 2008;
        public static final int PROMPT_UNKNOWN = 3000;
        public static final int PROMPT_ACTIVITY_DESTROY = 3001;
        public static final int DOWNLOAD_FAILED = 4000;
        public static final int DOWNLOAD_PERMISSION_DENIED = 4001;
        public static final int INSTALL_FAILED = 5000;
        public static final int UPDATE_UNKNOWN = 5100;
    }
}

