/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.entity;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xuexiang.xupdate.entity.DownloadEntity;
import com.xuexiang.xupdate.proxy.IUpdateHttpService;

public class UpdateEntity
implements Parcelable {
    private boolean mHasUpdate;
    private boolean mIsForce;
    private boolean mIsIgnorable;
    private int mVersionCode;
    private String mVersionName;
    private String mUpdateContent;
    private DownloadEntity mDownloadEntity;
    private boolean mIsSilent;
    private boolean mIsAutoInstall;
    public static final Parcelable.Creator<UpdateEntity> CREATOR = new Parcelable.Creator<UpdateEntity>(){

        public UpdateEntity createFromParcel(Parcel in) {
            return new UpdateEntity(in);
        }

        public UpdateEntity[] newArray(int size) {
            return new UpdateEntity[size];
        }
    };
    private IUpdateHttpService mIUpdateHttpService;

    public UpdateEntity() {
        this.mVersionName = "unknown_version";
        this.mDownloadEntity = new DownloadEntity();
        this.mIsAutoInstall = true;
    }

    protected UpdateEntity(Parcel in) {
        this.mHasUpdate = in.readByte() != 0;
        this.mIsForce = in.readByte() != 0;
        this.mIsIgnorable = in.readByte() != 0;
        this.mVersionCode = in.readInt();
        this.mVersionName = in.readString();
        this.mUpdateContent = in.readString();
        this.mDownloadEntity = (DownloadEntity)in.readParcelable(DownloadEntity.class.getClassLoader());
        this.mIsSilent = in.readByte() != 0;
        this.mIsAutoInstall = in.readByte() != 0;
    }

    public boolean isHasUpdate() {
        return this.mHasUpdate;
    }

    public UpdateEntity setHasUpdate(boolean hasUpdate) {
        this.mHasUpdate = hasUpdate;
        return this;
    }

    public boolean isForce() {
        return this.mIsForce;
    }

    public UpdateEntity setForce(boolean force) {
        if (force) {
            this.mIsIgnorable = false;
        }
        this.mIsForce = force;
        return this;
    }

    public boolean isIgnorable() {
        return this.mIsIgnorable;
    }

    public UpdateEntity setIsIgnorable(boolean isIgnorable) {
        if (isIgnorable) {
            this.mIsForce = false;
        }
        this.mIsIgnorable = isIgnorable;
        return this;
    }

    public boolean isSilent() {
        return this.mIsSilent;
    }

    public UpdateEntity setIsSilent(boolean isSilent) {
        this.mIsSilent = isSilent;
        return this;
    }

    public boolean isAutoInstall() {
        return this.mIsAutoInstall;
    }

    public UpdateEntity setIsAutoInstall(boolean isAutoInstall) {
        this.mIsAutoInstall = isAutoInstall;
        return this;
    }

    public UpdateEntity setApkCacheDir(String apkCacheDir) {
        if (!TextUtils.isEmpty((CharSequence)apkCacheDir) && TextUtils.isEmpty((CharSequence)this.mDownloadEntity.getCacheDir())) {
            this.mDownloadEntity.setCacheDir(apkCacheDir);
        }
        return this;
    }

    public void setIsAutoMode(boolean isAutoMode) {
        if (isAutoMode) {
            this.mIsSilent = true;
            this.mIsAutoInstall = true;
            this.mDownloadEntity.setShowNotification(true);
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public UpdateEntity setVersionCode(int versionCode) {
        this.mVersionCode = versionCode;
        return this;
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    public UpdateEntity setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    public String getUpdateContent() {
        return this.mUpdateContent;
    }

    public UpdateEntity setUpdateContent(String updateContent) {
        this.mUpdateContent = updateContent;
        return this;
    }

    public String getDownloadUrl() {
        return this.mDownloadEntity.getDownloadUrl();
    }

    public UpdateEntity setDownloadUrl(String downloadUrl) {
        this.mDownloadEntity.setDownloadUrl(downloadUrl);
        return this;
    }

    public String getMd5() {
        return this.mDownloadEntity.getMd5();
    }

    public UpdateEntity setMd5(String md5) {
        this.mDownloadEntity.setMd5(md5);
        return this;
    }

    public long getSize() {
        return this.mDownloadEntity.getSize();
    }

    public UpdateEntity setSize(long size) {
        this.mDownloadEntity.setSize(size);
        return this;
    }

    public String getApkCacheDir() {
        return this.mDownloadEntity.getCacheDir();
    }

    public UpdateEntity setDownLoadEntity(@NonNull DownloadEntity downloadEntity) {
        this.mDownloadEntity = downloadEntity;
        return this;
    }

    @NonNull
    public DownloadEntity getDownLoadEntity() {
        return this.mDownloadEntity;
    }

    public UpdateEntity setIUpdateHttpService(IUpdateHttpService updateHttpService) {
        this.mIUpdateHttpService = updateHttpService;
        return this;
    }

    public IUpdateHttpService getIUpdateHttpService() {
        return this.mIUpdateHttpService;
    }

    public String toString() {
        return "UpdateEntity{mHasUpdate=" + this.mHasUpdate + ", mIsForce=" + this.mIsForce + ", mIsIgnorable=" + this.mIsIgnorable + ", mVersionCode=" + this.mVersionCode + ", mVersionName='" + this.mVersionName + '\'' + ", mUpdateContent='" + this.mUpdateContent + '\'' + ", mDownloadEntity=" + this.mDownloadEntity + ", mIsSilent=" + this.mIsSilent + ", mIsAutoInstall=" + this.mIsAutoInstall + ", mIUpdateHttpService=" + this.mIUpdateHttpService + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.mHasUpdate ? 1 : 0));
        dest.writeByte((byte)(this.mIsForce ? 1 : 0));
        dest.writeByte((byte)(this.mIsIgnorable ? 1 : 0));
        dest.writeInt(this.mVersionCode);
        dest.writeString(this.mVersionName);
        dest.writeString(this.mUpdateContent);
        dest.writeParcelable((Parcelable)this.mDownloadEntity, flags);
        dest.writeByte((byte)(this.mIsSilent ? 1 : 0));
        dest.writeByte((byte)(this.mIsAutoInstall ? 1 : 0));
    }
}

