/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import com.xuexiang.xupdate._XUpdate;
import com.xuexiang.xupdate.entity.PromptEntity;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.listener.IUpdateParseCallback;
import com.xuexiang.xupdate.logs.UpdateLog;
import com.xuexiang.xupdate.proxy.IUpdateChecker;
import com.xuexiang.xupdate.proxy.IUpdateDownloader;
import com.xuexiang.xupdate.proxy.IUpdateHttpService;
import com.xuexiang.xupdate.proxy.IUpdateParser;
import com.xuexiang.xupdate.proxy.IUpdatePrompter;
import com.xuexiang.xupdate.proxy.IUpdateProxy;
import com.xuexiang.xupdate.proxy.impl.DefaultUpdatePrompter;
import com.xuexiang.xupdate.service.OnFileDownloadListener;
import com.xuexiang.xupdate.utils.UpdateUtils;
import java.util.Map;
import java.util.TreeMap;

public class UpdateManager
implements IUpdateProxy {
    private IUpdateProxy mIUpdateProxy;
    private UpdateEntity mUpdateEntity;
    private Context mContext;
    private String mUpdateUrl;
    private Map<String, Object> mParams;
    private String mApkCacheDir;
    private boolean mIsWifiOnly;
    private boolean mIsGet;
    private boolean mIsAutoMode;
    private IUpdateHttpService mIUpdateHttpService;
    private IUpdateChecker mIUpdateChecker;
    private IUpdateParser mIUpdateParser;
    private IUpdateDownloader mIUpdateDownloader;
    private OnFileDownloadListener mOnFileDownloadListener;
    private IUpdatePrompter mIUpdatePrompter;
    private PromptEntity mPromptEntity;

    private UpdateManager(Builder builder) {
        this.mContext = builder.context;
        this.mUpdateUrl = builder.updateUrl;
        this.mParams = builder.params;
        this.mApkCacheDir = builder.apkCacheDir;
        this.mIsWifiOnly = builder.isWifiOnly;
        this.mIsGet = builder.isGet;
        this.mIsAutoMode = builder.isAutoMode;
        this.mIUpdateHttpService = builder.updateHttpService;
        this.mIUpdateChecker = builder.updateChecker;
        this.mIUpdateParser = builder.updateParser;
        this.mIUpdateDownloader = builder.updateDownLoader;
        this.mOnFileDownloadListener = builder.onFileDownloadListener;
        this.mIUpdatePrompter = builder.updatePrompter;
        this.mPromptEntity = builder.promptEntity;
    }

    public UpdateManager setIUpdateProxy(IUpdateProxy updateProxy) {
        this.mIUpdateProxy = updateProxy;
        return this;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public IUpdateHttpService getIUpdateHttpService() {
        return this.mIUpdateHttpService;
    }

    @Override
    public void update() {
        UpdateLog.d("XUpdate.update()\u542f\u52a8:" + this.toString());
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.update();
        } else {
            this.doUpdate();
        }
    }

    private void doUpdate() {
        this.onBeforeCheck();
        if (this.mIsWifiOnly) {
            if (UpdateUtils.checkWifi(this.mContext)) {
                this.checkVersion();
            } else {
                this.onAfterCheck();
                _XUpdate.onUpdateError(2001);
            }
        } else if (UpdateUtils.checkNetwork(this.mContext)) {
            this.checkVersion();
        } else {
            this.onAfterCheck();
            _XUpdate.onUpdateError(2002);
        }
    }

    @Override
    public void onBeforeCheck() {
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.onBeforeCheck();
        } else {
            this.mIUpdateChecker.onBeforeCheck();
        }
    }

    @Override
    public void checkVersion() {
        UpdateLog.d("\u5f00\u59cb\u68c0\u67e5\u7248\u672c\u4fe1\u606f...");
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.checkVersion();
        } else {
            if (TextUtils.isEmpty((CharSequence)this.mUpdateUrl)) {
                throw new NullPointerException("[UpdateManager] : mUpdateUrl \u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.mIUpdateChecker.checkVersion(this.mIsGet, this.mUpdateUrl, this.mParams, this);
        }
    }

    @Override
    public void onAfterCheck() {
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.onAfterCheck();
        } else {
            this.mIUpdateChecker.onAfterCheck();
        }
    }

    @Override
    public boolean isAsyncParser() {
        if (this.mIUpdateProxy != null) {
            return this.mIUpdateProxy.isAsyncParser();
        }
        return this.mIUpdateParser.isAsyncParser();
    }

    @Override
    public UpdateEntity parseJson(@NonNull String json) throws Exception {
        UpdateLog.i("\u670d\u52a1\u7aef\u8fd4\u56de\u7684\u6700\u65b0\u7248\u672c\u4fe1\u606f:" + json);
        this.mUpdateEntity = this.mIUpdateProxy != null ? this.mIUpdateProxy.parseJson(json) : this.mIUpdateParser.parseJson(json);
        this.mUpdateEntity = this.refreshParams(this.mUpdateEntity);
        return this.mUpdateEntity;
    }

    @Override
    public void parseJson(@NonNull String json, final IUpdateParseCallback callback) throws Exception {
        UpdateLog.i("\u670d\u52a1\u7aef\u8fd4\u56de\u7684\u6700\u65b0\u7248\u672c\u4fe1\u606f:" + json);
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.parseJson(json, new IUpdateParseCallback(){

                @Override
                public void onParseResult(UpdateEntity updateEntity) {
                    UpdateManager.this.mUpdateEntity = UpdateManager.this.refreshParams(updateEntity);
                    callback.onParseResult(updateEntity);
                }
            });
        } else {
            this.mIUpdateParser.parseJson(json, new IUpdateParseCallback(){

                @Override
                public void onParseResult(UpdateEntity updateEntity) {
                    UpdateManager.this.mUpdateEntity = UpdateManager.this.refreshParams(updateEntity);
                    callback.onParseResult(updateEntity);
                }
            });
        }
    }

    private UpdateEntity refreshParams(UpdateEntity updateEntity) {
        if (updateEntity != null) {
            updateEntity.setApkCacheDir(this.mApkCacheDir);
            updateEntity.setIsAutoMode(this.mIsAutoMode);
            updateEntity.setIUpdateHttpService(this.mIUpdateHttpService);
        }
        return updateEntity;
    }

    @Override
    public void findNewVersion(@NonNull UpdateEntity updateEntity, @NonNull IUpdateProxy updateProxy) {
        UpdateLog.i("\u53d1\u73b0\u65b0\u7248\u672c:" + updateEntity);
        if (updateEntity.isSilent()) {
            if (!UpdateUtils.isApkDownloaded(updateEntity)) {
                this.startDownload(updateEntity, this.mOnFileDownloadListener);
            } else {
                _XUpdate.startInstallApk(this.getContext(), UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity), this.mUpdateEntity.getDownLoadEntity());
            }
        } else if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.findNewVersion(updateEntity, updateProxy);
        } else if (this.mIUpdatePrompter instanceof DefaultUpdatePrompter) {
            if (this.mContext != null && !((Activity)this.mContext).isFinishing()) {
                this.mIUpdatePrompter.showPrompt(updateEntity, updateProxy, this.mPromptEntity);
            } else {
                _XUpdate.onUpdateError(3001);
            }
        } else {
            this.mIUpdatePrompter.showPrompt(updateEntity, updateProxy, this.mPromptEntity);
        }
    }

    @Override
    public void noNewVersion(@NonNull Throwable throwable) {
        UpdateLog.i("\u672a\u53d1\u73b0\u65b0\u7248\u672c:" + throwable.getMessage());
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.noNewVersion(throwable);
        } else {
            _XUpdate.onUpdateError(2004, throwable.getMessage());
        }
    }

    @Override
    public void startDownload(@NonNull UpdateEntity updateEntity, @Nullable OnFileDownloadListener downloadListener) {
        UpdateLog.i("\u5f00\u59cb\u4e0b\u8f7d\u66f4\u65b0\u6587\u4ef6:" + updateEntity);
        updateEntity.setIUpdateHttpService(this.mIUpdateHttpService);
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.startDownload(updateEntity, downloadListener);
        } else {
            this.mIUpdateDownloader.startDownload(updateEntity, downloadListener);
        }
    }

    @Override
    public void backgroundDownload() {
        UpdateLog.i("\u70b9\u51fb\u4e86\u540e\u53f0\u66f4\u65b0\u6309\u94ae, \u5728\u901a\u77e5\u680f\u4e2d\u663e\u793a\u4e0b\u8f7d\u8fdb\u5ea6...");
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.backgroundDownload();
        } else {
            this.mIUpdateDownloader.backgroundDownload();
        }
    }

    @Override
    public void cancelDownload() {
        UpdateLog.d("\u6b63\u5728\u53d6\u6d88\u66f4\u65b0\u6587\u4ef6\u7684\u4e0b\u8f7d...");
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.cancelDownload();
        } else {
            this.mIUpdateDownloader.cancelDownload();
        }
    }

    @Override
    public void recycle() {
        UpdateLog.d("\u6b63\u5728\u56de\u6536\u8d44\u6e90...");
        if (this.mIUpdateProxy != null) {
            this.mIUpdateProxy.recycle();
            this.mIUpdateProxy = null;
        }
        this.mContext = null;
        if (this.mParams != null) {
            this.mParams.clear();
        }
        this.mIUpdateHttpService = null;
        this.mIUpdateChecker = null;
        this.mIUpdateParser = null;
        this.mIUpdateDownloader = null;
        this.mOnFileDownloadListener = null;
        this.mIUpdatePrompter = null;
    }

    public void download(String downloadUrl, @Nullable OnFileDownloadListener downloadListener) {
        this.startDownload(this.refreshParams(new UpdateEntity().setDownloadUrl(downloadUrl)), downloadListener);
    }

    public void update(UpdateEntity updateEntity) {
        this.mUpdateEntity = this.refreshParams(updateEntity);
        try {
            UpdateUtils.processUpdateEntity(this.mUpdateEntity, "\u8fd9\u91cc\u8c03\u7528\u7684\u662f\u76f4\u63a5\u66f4\u65b0\u65b9\u6cd5\uff0c\u56e0\u6b64\u6ca1\u6709json!", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "XUpdate{mUpdateUrl='" + this.mUpdateUrl + '\'' + ", mParams=" + this.mParams + ", mApkCacheDir='" + this.mApkCacheDir + '\'' + ", mIsWifiOnly=" + this.mIsWifiOnly + ", mIsGet=" + this.mIsGet + ", mIsAutoMode=" + this.mIsAutoMode + '}';
    }

    public static class Builder {
        Context context;
        String updateUrl;
        Map<String, Object> params;
        IUpdateHttpService updateHttpService;
        IUpdateParser updateParser;
        boolean isGet;
        boolean isWifiOnly;
        boolean isAutoMode;
        IUpdateChecker updateChecker;
        PromptEntity promptEntity;
        IUpdatePrompter updatePrompter;
        IUpdateDownloader updateDownLoader;
        OnFileDownloadListener onFileDownloadListener;
        String apkCacheDir;

        Builder(@NonNull Context context) {
            this.context = context;
            this.params = new TreeMap<String, Object>();
            if (_XUpdate.getParams() != null) {
                this.params.putAll(_XUpdate.getParams());
            }
            this.promptEntity = new PromptEntity();
            this.updateHttpService = _XUpdate.getIUpdateHttpService();
            this.updateChecker = _XUpdate.getIUpdateChecker();
            this.updateParser = _XUpdate.getIUpdateParser();
            this.updateDownLoader = _XUpdate.getIUpdateDownLoader();
            this.isGet = _XUpdate.isGet();
            this.isWifiOnly = _XUpdate.isWifiOnly();
            this.isAutoMode = _XUpdate.isAutoMode();
            this.apkCacheDir = _XUpdate.getApkCacheDir();
        }

        public Builder updateUrl(@NonNull String updateUrl) {
            this.updateUrl = updateUrl;
            return this;
        }

        public Builder params(@NonNull Map<String, Object> params) {
            this.params.putAll(params);
            return this;
        }

        public Builder param(@NonNull String key, @NonNull Object value) {
            this.params.put(key, value);
            return this;
        }

        public Builder updateHttpService(@NonNull IUpdateHttpService updateHttpService) {
            this.updateHttpService = updateHttpService;
            return this;
        }

        public Builder apkCacheDir(@NonNull String apkCacheDir) {
            this.apkCacheDir = apkCacheDir;
            return this;
        }

        public Builder isGet(boolean isGet) {
            this.isGet = isGet;
            return this;
        }

        public Builder isAutoMode(boolean isAutoMode) {
            this.isAutoMode = isAutoMode;
            return this;
        }

        public Builder isWifiOnly(boolean isWifiOnly) {
            this.isWifiOnly = isWifiOnly;
            return this;
        }

        public Builder updateChecker(@NonNull IUpdateChecker updateChecker) {
            this.updateChecker = updateChecker;
            return this;
        }

        public Builder updateParser(@NonNull IUpdateParser updateParser) {
            this.updateParser = updateParser;
            return this;
        }

        public Builder updatePrompter(@NonNull IUpdatePrompter updatePrompter) {
            this.updatePrompter = updatePrompter;
            return this;
        }

        public Builder setOnFileDownloadListener(OnFileDownloadListener onFileDownloadListener) {
            this.onFileDownloadListener = onFileDownloadListener;
            return this;
        }

        @Deprecated
        public Builder themeColor(@ColorInt int themeColor) {
            this.promptEntity.setThemeColor(themeColor);
            return this;
        }

        public Builder promptThemeColor(@ColorInt int themeColor) {
            this.promptEntity.setThemeColor(themeColor);
            return this;
        }

        @Deprecated
        public Builder topResId(@DrawableRes int topResId) {
            this.promptEntity.setTopResId(topResId);
            return this;
        }

        public Builder promptTopResId(@DrawableRes int topResId) {
            this.promptEntity.setTopResId(topResId);
            return this;
        }

        public Builder supportBackgroundUpdate(boolean supportBackgroundUpdate) {
            this.promptEntity.setSupportBackgroundUpdate(supportBackgroundUpdate);
            return this;
        }

        public Builder promptWidthRatio(float widthRatio) {
            this.promptEntity.setWidthRatio(widthRatio);
            return this;
        }

        public Builder promptHeightRatio(float heightRatio) {
            this.promptEntity.setHeightRatio(heightRatio);
            return this;
        }

        public Builder updateDownLoader(@NonNull IUpdateDownloader updateDownLoader) {
            this.updateDownLoader = updateDownLoader;
            return this;
        }

        public UpdateManager build() {
            UpdateUtils.requireNonNull(this.context, "[UpdateManager.Builder] : context == null");
            UpdateUtils.requireNonNull(this.updateHttpService, "[UpdateManager.Builder] : updateHttpService == null");
            if (this.updatePrompter == null) {
                if (this.context instanceof FragmentActivity) {
                    this.updatePrompter = new DefaultUpdatePrompter(((FragmentActivity)this.context).getSupportFragmentManager());
                } else if (this.context instanceof Activity) {
                    this.updatePrompter = new DefaultUpdatePrompter();
                } else {
                    throw new UnsupportedOperationException("[UpdateManager.Builder] : \u4f7f\u7528\u9ed8\u8ba4\u7684\u7248\u672c\u66f4\u65b0\u63d0\u793a\u5668\uff0ccontext\u5fc5\u987b\u4f20Activity\uff01");
                }
            }
            if (TextUtils.isEmpty((CharSequence)this.apkCacheDir)) {
                this.apkCacheDir = UpdateUtils.getDefaultDiskCacheDirPath();
            }
            return new UpdateManager(this);
        }

        public void update() {
            this.build().update();
        }

        public void update(IUpdateProxy updateProxy) {
            this.build().setIUpdateProxy(updateProxy).update();
        }
    }
}

